
# cgi-lib@pobox.com
# $Id: cgi-lib.pl,v 2.18 1999/02/23 08:16:43 brenner Exp $
# Copyright (c) 1993-1999 Steven E. Brenner
# version = 2.18


sub ReadParse {
my($len,$type,$meth,$errflag,$got,$name);
my(%in,%incfn,%inct);
my($buf,$boundary,$head,@heads,$cd,$ct,$fname,$ctype,$blen);
my($bpos,$lpos,$left,$amt);
my($bufsize,$maxbound);
my($limit,$i,$maxdata);
my($errmsg,$value,$upidx,$csvfilename,$t_fname,$na,@inname);

binmode(STDIN);
binmode(STDOUT);
binmode(STDERR);

$type = $ENV{'CONTENT_TYPE'};
$len  = $ENV{'CONTENT_LENGTH'};
$meth = $ENV{'REQUEST_METHOD'};

$maxdata=200000000;

if ($len > $maxdata) {
	&CgiDie("cgi-lib.pl: Request to receive too much data: $len bytes\n");
}

$bufsize=8192;
$maxbound=100;

$buf = ''; 

($boundary) = $type =~ /boundary="([^"]+)"/;
($boundary) = $type =~ /boundary=(\S+)/ unless $boundary;
&CgiDie ("Boundary not provided: probably a bug in your server") unless $boundary;
$boundary =  "--" . $boundary;
$blen = length ($boundary);

if ($ENV{'REQUEST_METHOD'} ne 'POST') {
	&CgiDie("Invalid request method for  multipart/form-data: $meth\n");
}
@inname=();
$limit=10000;
$i=0;
$left = $len;
PART:
while (1) {
	$i++;
	die $@ if $errflag;

	$amt = ($left > $bufsize+$maxbound-length($buf) ?  $bufsize+$maxbound-length($buf): $left);
	$errflag = (($got = read(STDIN, $buf, $amt, length($buf))) != $amt);
	die "Short Read: wanted $amt, got $got\n" if $errflag;
	$left -= $amt;

	BODY: 
	while (($bpos = index($buf, $boundary)) == -1) {
		if ($left == 0 && $buf eq '') {
			&CgiDie("cgi-lib.pl: reached end of input while seeking boundary of multipart. Format of CGI input is wrong.\n");
		}
		die $@ if $errflag;
		if ($name) {
			$data=substr($buf, 0, $bufsize);
			$in{$name} .= $data;
		}
		$buf = substr($buf, $bufsize);
		$amt = ($left > $bufsize ? $bufsize : $left); #$maxbound==length($buf);
		$errflag = (($got = read(STDIN, $buf, $amt, length($buf))) != $amt);
		die "Short Read: wanted $amt, got $got\n" if $errflag;
		$left -= $amt;
		$i++;
		if($i > $limit){
			&CgiDie("cgi-lib.pl: loop error\n");
		}
	}
	if (defined $name) {
		$data=substr($buf, 0, $bpos-2);
		$in{$name} .= $data;
	}

	last PART if substr($buf, $bpos + $blen, 2) eq "--";
	substr($buf, 0, $bpos+$blen+2) = '';
	$amt = ($left > $bufsize+$maxbound-length($buf) ? $bufsize+$maxbound-length($buf) : $left);
	$errflag = (($got = read(STDIN, $buf, $amt, length($buf))) != $amt);
	die "Short Read: wanted $amt, got $got\n" if $errflag;
	$left -= $amt;
	undef $head;
	HEAD:
	while (($lpos = index($buf, "\r\n\r\n")) == -1) { 
		if ($left == 0  && $buf eq '') {
			&CgiDie("cgi-lib: reached end of input while seeking end of headers. Format of CGI input is wrong.\n");
		}
		die $@ if $errflag;
		$head .= substr($buf, 0, $bufsize);
		$buf = substr($buf, $bufsize);
		$amt = ($left > $bufsize ? $bufsize : $left); #$maxbound==length($buf);
		$errflag = (($got = read(STDIN, $buf, $amt, length($buf))) != $amt);
		die "Short Read: wanted $amt, got $got\n" if $errflag;
		$left -= $amt;
		$i++;
		if($i > $limit){
			&CgiDie("cgi-lib.pl: loop error\n");
		}
	}
	$head .= substr($buf, 0, $lpos+2);

	@heads = split("\r\n", $head);
	($cd) = grep (/^\s*Content-Disposition:/i, @heads);
	($ct) = grep (/^\s*Content-Type:/i, @heads);

	($name) = $cd =~ /\bname="([^"]+)"/i; 
	($name) = $cd =~ /\bname=([^\s:;]+)/i unless defined $name;
	if($name eq ""){
		&CgiDie("cgi-lib.pl: name error\n");
	}
	if(defined $in{$name}){
		&CgiDie("cgi-lib.pl: same input name $name\n");
	}
	push @inname,$name;
	($fname) = $cd =~ /\bfilename="([^"]*)"/i;
	($fname) = $cd =~ /\bfilename=([^\s:;]+)/i unless defined $fname;

	$incfn{$name} = $fname;

	($ctype) = $ct =~ /^\s*Content-type:\s*"([^"]+)"/i;
	($ctype) = $ct =~ /^\s*Content-Type:\s*([^\s:;]+)/i unless defined $ctype;

	$inct{$name} = $ctype;

	substr($buf, 0, $lpos+4) = '';
	undef $fname;
	undef $ctype;

	if($i > $limit){
		&CgiDie("cgi-lib.pl: loop error\n");
	}
}

if($errflag){
	$errmsg = $@ || $errflag;
	&CgiDie($errmsg);
}

return(\@inname,\%in,\%incfn,\%inct);
}


sub CgiError {
my (@msg) = @_;
my ($i,$name);

if (!@msg) {
	@msg = ("Error: script $name encountered fatal error\n");
}

print "Content-type: text/html\n\n";
print "<html>\n<head>\n<title>$msg[0]</title>\n</head>\n<body>\n";

print "<p>$msg[0]</p>\n";
foreach $i (1 .. $#msg) {
	print "<p>$msg[$i]</p>\n";
}

}

sub CgiDie {
my (@msg) = @_;
&CgiError (@msg);
die @msg;
}

1;
