#!/usr/bin/perl

$ENV{'TZ'} = "JST-9";

#Cart Z ver.16.5 by CGI Pal

#設置の仕方などはreadme.txtをご覧ください。

package CF;

#************************ 設定項目 *******************************

#-------------------注文・確認メールの設定------------------------

#確認メールの前後に表示するメッセージを記入します。
#前の文は$email_headerに、後の文は$email_footerに記入

$email_header=<<'EOM';
ご注文ありがとうございます。
送信されたメールの内容は以下のようになっておりますので
ご確認ください。
EOM

$email_footer=<<'EOM';
どうもありがとうございました。

---------------------------
hoge@ne.jp
http://hoge.ne.jp
---------------------------
EOM

$shop='ショップ名';					#ショップ名を設定
$chk_mailsub='ご注文ありがとうございます。';		#確認メールの件名を設定
$rcpt_mailsub='注文メール';				#ショップに届く件名
$checkmail='1';						#確認メールを送るか(0送らない:1:送る)

$mailto='user1@sample.com';		#注文のメールを受け取る人(あなた)のメールアドレス
$mailto2='';			#注文メールをもう一つ送るときは''の中に記入

#-------------- 消費税 --------------------

$taxrate='10';		#消費税率(%) 税をかけないときは0にする
$taxrate_betu='0';	#もう1つの消費税率(%) 税をかけないときは0にする
			#ここに税率を設定したときは、この税率を適用する商品のフォームタグに<input type="hidden" name="tax" value="1">と設定

$zei='1';		#税の表示方式(0:税抜価格を元に税額を出す 1:税込価格を元に税額を出す)
			#0にした場合は、カタログページの<input type="hidden" name="price" value="値段">には
			#税抜きの価格を記入すること。
			#1にした場合は、カタログページの<input type="hidden" name="price" value="値段">には
			#税込みの価格を記入すること。


#-------------- 送料 --------------------

$postage='4';			#送料について 
				#0:計算しない 
				#1:どの商品を何個買っても送料は一定金額 
				#2:全ての商品の送料が同じ 
				#3:商品ごとに違う送料を設定 
				#4:配送方法によって送料を計算

$postage_alt='別途請求';	#$postageを0にして、送料を表示計算しないとき、代わりに文字を表示するときは、''の中に'別途申し請け'などと記入(不要のときは'')
$postage_fix='500';		#$postageを1にしたときは、ここに一定にする送料を記入
$postage_each='500';		#$postageを2にしたときは、ここに一定にする送料を記入

$postage_off='1';		#購入金額が一定以上のときは送料を無料にするときは、1にして、下の$postage_lineで金額指定 $postageの1～4で有効
$postage_line='10000';		#購入金額がこの金額以上なら送料は無料にする
$postage_muryo='1';		#$postage_offを1にしたときに、あと～円の購入で送料が無料に!!と表示するか(0:しない 1:する)


#----------------配送方法--------------------


@deliver=(
'ゆうパック',
'佐川急便',
'クロネコヤマト',
'定形外郵便',
'メール便',
);

#使用する配送方法を設定　不要なものは削除するか、#'ゆうパック',のように先頭に#をつける

$deliver_show='0';		#配送方法を消すか (0:消さない 1:消す)
				#配送方法が1つだけに決まっていて、表示する必要のないときは1にしてください

$delivercheck='ゆうパック';	#チェックを入れた状態にしたい配送方法があれば記入

#----------------カート画面での送料の計算--------------------

$cartpos='1';			#カート画面で送料計算するか(0:計算しない 1:計算する)$postageが4の場合に有効
$cartposdeli='ゆうパック';	#$cartposを1にした場合は、@deliverに設定した配送方法の中から、カート画面で送料計算する配送方法を記入

#----------------お支払い方法--------------------

@pay=(
'銀行振込',
'代金引換',
'eコレクト',
'クロネコWebコレクト',
);

#使用するお支払い方法

$paycheck='銀行振込';		#チェックを入れた状態にしたいお支払い方法があれば記入

#----------------クロネコWebコレクトの設定----------

$trader_code='012345678';
#お支払い方法でクロネコWebコレクトを使うようにした場合は
#ここにtrader_codeを設定

#----------------手数料--------------------

$dai_count_on='1';		#代金引換などのときにその手数料を計算する 1:する0:しない

%dai_count=(
'代金引換'=>'250',
);

#$dai_count_onを1にしたときはここに各お支払い方法の料金を
#'お支払い方法'=>'その料金',のように設定
#%にするときは5%などと設定
#購入金額が10000円未満は250円、10000円以上20000円未満は350円、20000以上は450円とするときは、
#'10000:20000_250:350:450'と設定

$dai_off='0';			#購入金額が一定以上のときは手数料を無料にするときは、1にして、下の$dai_lineで金額指定
$dai_line='10000';		#購入金額がこの金額以上なら手数料は無料にする

#-------------------各お支払い方法の連絡文------------------------

$tenp_pay='0';			#お支払い方法別に連絡文をつけるか(0:つけない 1:つける)
				#1にしたときは下に各お支払い方法の連絡文を設定($xxxx=<<'COM';とCOMの間に記入)

$paymsg_bank=<<'COM';
銀行振込のときの連絡文

COM

$paymsg_dai=<<'COM';
代金引換のときの連絡文

COM

$paymsg_e=<<'COM';
eコレクトのときの連絡文

COM

#---------------------csvファイル-------------------------------

$csv='1';		#csvファイルをメールに添付する 1:する0:しない
$csvfile='data';	#添付するcsvファイルの名前

#---------------------注文番号-------------------------------

$id='0';			#注文番号の形式 0:ランダムな数字 1:ランダムな文字列 2:ランダムな数字と文字列
$id_title='1';			#注文番号をメールのタイトルにつけるか 0:つけない 1:つける
$id_filename='0';		#cvsファイルの名前を注文番号にするか 0:しない 1:する

#---------------------割引-------------------------------

$waribiki='0';		#割引をする(0:しない 1:する)
$wariritu='10';		#割引率(%)

#------------------- その他 -------------------------------

$pd='rUiITX9c';		#個人情報のクッキーを暗号化するパスワード(必ず変更すること。何文字でもいいですが半角英数字で8文字以上にしてください。)
$c_valid='365';		#購入者のクッキーを保存する日数
$wh='25';		#カート画面での画像の縦横サイズ

$yen='1';		#円の表示 0:円 1:\

$zaiko='0';		#在庫管理をする(0:しない 1:する)
$operror='1';		#サイズなどのオプションを選択していないときにエラーを出すか

#------------------- 以下は変更の必要なし ---------------------------

$cart='cart.html';		#買い物かごのメイン画面のHTML(スキン)
$enter='enter.html';		#お客様情報入力のためのHTML
$confirm='confirm.html';		#入力情報確認のためのHTML(スキン)
$thanks='thanks.html';		#終了画面
$sendmail='/usr/sbin/sendmail';	#sendmailのパス

$g_log="log/goods.log";		#ログ
$jslog='../cart_js/goods.js';		#ログ
$countlog='log/count.log';	#カウントを記録するファイル

$lockfile='log/lock';	#ロックファイル
$tmpdir='log/tmp/';
$mailpl='./lib/mail.pl';

@keys_cart=("number","name","price","amount","postage","tax","image","weight","pack","stock","cid","op");

$c_name="cartz";
$angoc_name="c_encoded";

@PREF=(
'北海道',
'青森県',
'岩手県',
'秋田県',
'宮城県',
'山形県',
'福島県',
'茨城県',
'栃木県',
'群馬県',
'埼玉県',
'千葉県',
'東京都',
'神奈川県',
'新潟県',
'富山県',
'石川県',
'福井県',
'長野県',
'山梨県',
'静岡県',
'愛知県',
'岐阜県',
'三重県',
'滋賀県',
'京都府',
'大阪府',
'兵庫県',
'奈良県',
'和歌山県',
'鳥取県',
'島根県',
'岡山県',
'広島県',
'山口県',
'香川県',
'徳島県',
'愛媛県',
'高知県',
'福岡県',
'大分県',
'佐賀県',
'長崎県',
'宮崎県',
'熊本県',
'鹿児島県',
'沖縄県',
);

#**************************** 設定はここまで **************************************

package main;

use Encode;

$maxsize='100000';

unless(-e './lib/functions.pl'){
	&error("lib/functions.plがありません。");
}
require './lib/functions.pl';

unless(-e './lib/purchase.pl'){
	&error("lib/perchase.plがありません。");
}
require './lib/purchase.pl';

if($ENV{'REQUEST_METHOD'} eq "POST"){
	if($ENV{'CONTENT_LENGTH'}>$maxsize){
		&error("投稿量が多すぎます。");
	}
	read(STDIN,$buff,$ENV{'CONTENT_LENGTH'});
}
else{
	$buff=$ENV{'QUERY_STRING'};
}

if($buff){
	&Dcd;
}

sub Dcd{
my($name,$value,$pair,@pairs);
@pairs=split(/&/,$buff);
foreach $pair(@pairs){
	($name,$value)=split(/=/,$pair);
	$value=~tr/+/ /;
	$value=~s/%([a-fA-F0-9][a-fA-F0-9])/pack("H2",$1)/eg;
	$value=~s/&/＆/g;
	$value=~s/</＜/g;
	$value=~s/>/＞/g;
	$value=~s/"/”/g;
	$value=~s/'/’/g;
	$value=~s/,//g;
	if($name eq "comment"){
		$value=~s/\x0D\x0A/\n/g;
		$value=~s/\x0D/\n/g;
		$value=~s/\x0A/\n/g;
	}
	else{
		$value=~s/\x0D\x0A//g;
		$value=~s/\x0D//g;
		$value=~s/\x0A//g;
	}
	$FORM{$name}=$value;

}
}

%COOKIE=&Functions::GetCookie;

if($FORM{'mode'} eq "del"){
	&Del;
}
elsif($FORM{'mode'} eq "clear"){
	&Clear;
}
elsif($FORM{'mode'} eq "regist"){
	&Regist;
}
elsif($FORM{'mode'} eq "view"){
	&View;
}
elsif($FORM{'mode'} eq "modify"){
	&Modify;
}
elsif($FORM{'mode'} eq "enter"){
	&Enter;
}
elsif($FORM{'mode'} eq "confirm"){
	&Confirm;
}
elsif($FORM{'mode'} eq "order"){
	&Order;
}
elsif($FORM{'mode'} eq "back"){
	&Back;
}
elsif($FORM{'mode'} eq "postal"){
	unless(-e './lib/postal.pl'){
		&error("lib/postal.plがありません。");
	}
	require './lib/postal.pl';
	&Search;
}
else{
	if($ENV{'REQUEST_METHOD'} eq "POST" && $ENV{'CONTENT_LENGTH'} == 0){	
		&error("エラーが発生しました。ブラウザの更新ボタンを押すと送信されます。","r");
	}
	else{
		&error("cart.cgiは直接起動できません。カタログページから呼び出してください。");
	}
}


sub View{
my($_sessid,$ref);

$_sessid=&Functions::GetSessId;

$ref=&Functions::OpenData($_sessid);

&Top($ref,$_sessid);

}


sub Regist{
my($i,$tmp,$_sessid,$ref,$newref,$a_total,@keys,%fo,$name,$num,@tmp,$cook,$flag);

if($CF::operror){
	$i=0;
	foreach(@opvalue){
		if($_ eq ""){
			if($opnamearray[$i] eq ""){
				$tmp="オプション";
			}
			else{
				$tmp=$opnamearray[$i];
			}
			&error("$tmpが選択されていません。");
		}
		$i++;
	}
}

$_sessid=&Functions::GetSessId;
$ref=&Functions::OpenData($_sessid);

($newref,$a_total)=&DoRegist($ref,\%FORM);

$cook="";
foreach(@{$newref}){
	$cook.=$_."\n";
}
if(!$_sessid){
	$_sessid=&Functions::MakeSess;
	&Functions::SetCookie($_sessid,$CF::c_name,"","","","");
}

&Functions::WriteData($_sessid,$cook);
&Functions::SetCookie($FORM{'page'},"page","","enc","","");

&Functions::SetCookie($a_total,"cart","root","","","");
&Top($newref,$_sessid);
exit;

}

sub DoRegist{
my($ref,$FO_ref,$flag,$idx,$a_total,@new,$number);
my($ctref,$l);

$ref=$_[0];
$FO_ref=$_[1];


if(${$FO_ref}{'op1'} || ${$FO_ref}{'op2'}){
	if(${$FO_ref}{'op1'}){
		if(${$FO_ref}{'op1'}=~/:/){
			(${$FO_ref}{'op1'},${$FO_ref}{'price'})=split(/:/,${$FO_ref}{'op1'});
		}
		push @tmp,${$FO_ref}{'op1'};
	}
	if(${$FO_ref}{'op2'}){
		push @tmp,${$FO_ref}{'op2'};
	}
	$opline=join(":",@tmp);
}

if(${$FO_ref}{'stock'} ne ""){
	$z_flag=1;
	if(${$FO_ref}{'stock'}==0){
		&msgerror("大変申し訳ありません。この商品は在庫が切れております。");
	}
	if(${$FO_ref}{'amount'}>${$FO_ref}{'stock'}){
		&msgerror("注文個数が在庫数より多くなっています。在庫数は${$FO_ref}{'stock'}です。");
	}
}


if(!${$FO_ref}{'amount'}){
	${$FO_ref}{'amount'}=1;
}

if(${$FO_ref}{'tax'}){
	${$FO_ref}{'tax'}=$CF::taxrate_betu;
}

$number=${$FO_ref}{'number'}.$opline;

$flag=0;
$idx=0;
$a_total=0;
@new=();
foreach $l(@{$ref}){
	$ctref=&Functions::SplitCart($l);
	$a_total+=${$ctref}{'amount'};
	$num_d=${$ctref}{'number'}.${$ctref}{'op'};
	if($num_d eq $number){
		$flag=1;
		${$ctref}{'amount'}+=${$FO_ref}{'amount'};
		if($z_flag==1){
			if(${$FO_ref}{'stock'} < ${$ctref}{'amount'} && $CF::zaiko){
				&msgerror("{${$ctref}{'name'}}の注文個数が在庫数より多くなっています。在庫数は$FORM{'stock'}です。");
			}
		}
		elsif($z_flag==2){
			if(${$FO_ref}{'stock'} < ${$ctref}{'amount'} && $CF::zaiko){
				&msgerror("{${$ctref}{'name'}}の{${$ctref}{'op'}}の注文個数が在庫数より多くなっています。在庫数は${$FO_ref}{'stock'}です。");
			}
		}
		$l=&Functions::MakeLine(\@CF::keys_cart,$ctref);
	}
	$new[$idx++]=$l;
}
if(!$flag){
	${$FO_ref}{'op'}=$opline;
	${$FO_ref}{'cid'}="";
	$new[$idx]=&Functions::MakeLine(\@CF::keys_cart,$FO_ref);
}

$a_total+=${$FO_ref}{'amount'};

return(\@new,$a_total);

}

sub CartMain{
my($act,$goods_ref,$footer_ref,$ref,$O_PCHS,$ar,$deliver,$s,$v,$prefline);

$act=$_[0];
$goods_ref=$_[1];
$footer_ref=$_[2];
$ref=$_[3];

$O_PCHS=Purchase->new();

$O_PCHS->GoodsCal($act,$goods_ref,$ref);

$O_PCHS->{'subtotal_o'}=$O_PCHS->{'subtotal'};#?
$O_PCHS->{'subtotal_o_c'}=&Functions::Comma($act,$O_PCHS->{'subtotal_o'});#?

if($CF::waribiki){
	$O_PCHS->{'subtotal'}-=$O_PCHS->{'wari'};
}


$O_PCHS->{'total'}=$O_PCHS->{'subtotal'};

if(!$CF::zei){
	$O_PCHS->{'total'}+=$O_PCHS->{'tax_all'};#?
}

if($CF::postage != 4){
	($O_PCHS->{'total'},$O_PCHS->{'postage_all'})=&Functions::PostageCal($O_PCHS->{'total'},$O_PCHS->{'subtotal'},$O_PCHS->{'postage_all'},$O_PCHS->{'a_total'});
}
else{
	if(($act eq "top") || ($act eq "enter")){
		if(!$FORM{'pref'}){
			$FORM{'pref'}='東京都';
		}
		
		$ar=$FORM{'pref'};
		$deliver=$CF::cartposdeli;
	}
	elsif(($act eq "confirm") || ($act eq "order")){
		$ar=$FORM{'pref_rcpt'} || $FORM{'pref'};
		$deliver=$FORM{'deliver'};
	}
	
	if(($act eq "top") || ($act eq "enter")){
		if($CF::cartpos){
			if($act eq "top"){
				$prefline=" <select name=\"pref\" onchange=\"CartPos(this)\">\n";
				foreach $v(@CF::PREF){
					if($v eq $ar){
						$s=" selected";
					}
					else{
						$s="";
					}
					$prefline.="<option value=\"$v\"$s>$v</option>\n";
				}
				$prefline.="</select>\nの場合";
			}
			else{
				$prefline='('.$ar."の場合".')';
			}
			${$footer_ref}=~s/<!--cartpos-->/$prefline/s;
		}
	}
	($O_PCHS->{'total'},$O_PCHS->{'postage_all'})=&Functions::PostageCal2($O_PCHS->{'total'},$O_PCHS->{'subtotal'},$O_PCHS->{'weight_all'},$O_PCHS->{'pack_all'},$deliver,$ar,$O_PCHS->{'a_total'});

}

if($CF::wrapping){
	($O_PCHS->{'wrap_charge'},$O_PCHS->{'total'})=&Functions::Wrap($O_PCHS->{'total'},$O_PCHS->{'subtotal'},$O_PCHS->{'wrap_count'});
	$O_PCHS->{'wrap_charge_c'}=&Functions::Comma($act,$O_PCHS->{'wrap_charge'});
}

if(($act eq "confirm") || ($act eq "order")){
	if($CF::dai_count_on){#?
		($O_PCHS->{'dai_charge'},$O_PCHS->{'total'},$O_PCHS->{'dai_name'})=&Functions::Dai($FORM{'pay'},$O_PCHS->{'total'},$O_PCHS->{'subtotal'});
		$O_PCHS->{'dai_charge_c'}=&Functions::Comma($act,$O_PCHS->{'dai_charge'});
	}
	else{
		if($act eq "confirm"){
			${$footer_ref} =~ s/<!--tesu-->.*?<!--\/tesu-->//s;
		}
	}
}

$O_PCHS->{'postage_all_c'}=&Functions::Comma($act,$O_PCHS->{'postage_all'});
$O_PCHS->{'tax_all_c'}=&Functions::Comma($act,$O_PCHS->{'tax_all'});#?


$O_PCHS->{'subtotal_c'}=&Functions::Comma($act,$O_PCHS->{'subtotal'});#?
$O_PCHS->{'total_c'}=&Functions::Comma($act,$O_PCHS->{'total'});

${$footer_ref} =~ s/<!--a_total-->/$O_PCHS->{'a_total'}."個"/;#?
${$footer_ref} =~ s/<!--tax-->/$O_PCHS->{'tax_all_c'}/;#?
${$footer_ref} =~ s/<!--total-->/$O_PCHS->{'total_c'}/;

if($O_PCHS->{'zei_old'}){
	$O_PCHS->{'subtotal_old_c'}=&Functions::Comma($act,$O_PCHS->{'subtotal_old'});
	$O_PCHS->{'subtotal_new_c'}=&Functions::Comma($act,$O_PCHS->{'subtotal_new'});
	$O_PCHS->{'tax_old_c'}=&Functions::Comma($act,$O_PCHS->{'tax_old'});
	$O_PCHS->{'tax_new_c'}=&Functions::Comma($act,$O_PCHS->{'tax_new'});
	
	${$footer_ref} =~ s/<!--subtotal_old-->/$O_PCHS->{'subtotal_old_c'}/;
	${$footer_ref} =~ s/<!--subtotal_new-->/$O_PCHS->{'subtotal_new_c'}/;
	${$footer_ref} =~ s/<!--tax_old-->/$O_PCHS->{'tax_old_c'}/;
	${$footer_ref} =~ s/<!--tax_new-->/$O_PCHS->{'tax_new_c'}/;
	${$footer_ref} =~ s/<!--zei_old-->/$O_PCHS->{'zei_old'}/g;
	${$footer_ref} =~ s/<!--zei_new-->/$CF::taxrate/g;
}
else{
	${$footer_ref} =~ s/<!--subtotal_keigen-->.*?<!--\/subtotal_keigen-->//s;
	${$footer_ref} =~ s/<!--tax_keigen-->.*?<!--\/tax_keigen-->//s;
}

if(!$CF::waribiki){
	${$footer_ref} =~ s/<!--subtotal-->/$O_PCHS->{'subtotal_c'}/;
	${$footer_ref} =~ s/<!--waribiki-->.*?<!--\/waribiki-->//s;
	${$footer_ref} =~ s/<!--warigo-->.*?<!--\/warigo-->//s;
}
else{
	${$footer_ref} =~ s/<!--subtotal-->/$O_PCHS->{'subtotal_o_c'}/;
	${$footer_ref} =~ s/<!--subtotal_w-->/$O_PCHS->{'subtotal_c'}/;

	$O_PCHS->{'wari_c'}=&Functions::Comma($act,$O_PCHS->{'wari'});

	${$footer_ref} =~ s/<!--wari-->/-$O_PCHS->{'wari_c'}/;

}

if(!$CF::postage){
	if($CF::postage_alt){
		${$footer_ref} =~ s/<!--postage-->/$CF::postage_alt/;
	}
	else{
		${$footer_ref} =~ s/<!--postage-->/$O_PCHS->{'postage_all_c'}/;
	}
}
elsif(($act eq "top" || $act eq "enter") && $CF::postage == 4 && !$CF::cartpos){
	${$footer_ref} =~ s/<!--postage-->/後ほど計算/;#?
}
else{
	${$footer_ref} =~ s/<!--postage-->/$O_PCHS->{'postage_all_c'}/;
}

return $O_PCHS;

}

sub msgerror{
print "Content-type: text/plain\n\n";
print "er:".$_[0];
exit;
}


sub Top{
my($ref,$_sessid,$skinline,$head,$dummy,$goods,$footer,$page);
my($O_PCHS,$muryo,$muryo_c,$tmp);

$ref=$_[0];
$_sessid=$_[1];


unless(open(HTML, $CF::cart)){
	&error("cartが開けません。ファイル名を確認してください。");
}
$skinline = join('',<HTML>);
close(HTML);

($head,$dummy) = split(/<!--goods-->/, $skinline);
if($head eq ""){
	&error("cartに&lt;!--goods--&gt;が書かれていません。");
}
($goods,$footer) = split(/<!--\/goods-->/, $dummy);
if($goods eq ""){
	&error("cartに&lt;!--/goods--&gt;が書かれていません。");
}

$page=&GetPage;

$footer=~s/\/\/--prev--/u="$page";/;

$O_PCHS=&CartMain('top',\$goods,\$footer,$ref);

$muryo=$CF::postage_line-$O_PCHS->{'subtotal'};

if($CF::postage && $CF::postage_muryo){
	if($muryo > 0){
		$muryo_c=&Functions::Comma("",$muryo);
		$tmp="<br>※あと$muryo_cのお買い物で送料が無料に!!";
	}
	else{
		$postage_line_c=&Functions::Comma("",$CF::postage_line);
		$tmp="<br>※$postage_line_c以上のお買い物ですので送料が無料!!";#?
	}
	$footer=~s/<!--muryo-->/$tmp/;
}


if(!scalar(@{$ref})){
	$footer =~ s/<!--enter-->.*?<!--\/enter-->//is;
	$footer =~ s/<!--clear-->.*?<!--\/clear-->//is;
	$footer =~ s/<!--modify-->.*?<!--\/modify-->//is;
	if($CF::viewmode && !$COOKIE{$CF::c_name}){
		$footer =~ s/<!--back-->.*?<!--\/back-->//is;
	}
}

$footer=~s/#pref/$FORM{'pref'}/;

print "Content-type: text/html\n\n";

print $head;
print $O_PCHS->{'g_line'};
print $footer;
exit;
}


sub Del{
my($_sessid,$ref,$idx,$a_total,$v,$ctref,$num,$cook,@new);


if(!$COOKIE{$CF::c_name}){
	&error("クッキーが無効になっているのでショッピングカートは使えません。");
}

$_sessid=&Functions::GetSessId;

$ref=&Functions::OpenData($_sessid);

$idx=0;
$a_total=0;
@new=();
foreach $v(@{$ref}){
	$ctref=&Functions::SplitCart($v);
	$num=${$ctref}{'number'}.${$ctref}{'op'};
	if($FORM{'num'} ne $num){
		$new[$idx++]=$v;
		$a_total+=${$ctref}{'amount'};
	}
}

$cook="";
foreach(@new){
	$cook.=$_."\n";
}

&Functions::WriteData($_sessid,$cook);

&Functions::SetCookie($a_total,"cart","root","","","");

&Top(\@new,$_sessid);

}

sub Clear{
my($_sessid,@new);


if(!$COOKIE{$CF::c_name}){
	&error("クッキーが無効になっているのでショッピングカートは使えません。");
}

$_sessid=&Functions::GetSessId;

&Functions::WriteData($_sessid,"");

&Functions::SetCookie("0","cart","root","","","");


@new=();
&Top(\@new,$_sessid);

}

sub Modify{
my(@keylist,$_sessid,$ref,$idx,$line,$flag,$ctref,$n_line,$n_line_d,$num_d,$cook,@new);


if(!$COOKIE{$CF::c_name}){
	&error("クッキーが無効になっているのでショッピングカートは使えません。");
}
@keylist=keys %FORM;
foreach(@keylist){
	if($_=~/^mdfy_/){
		push(@goodsnum,$_);
	}
}

$_sessid=&Functions::GetSessId;
$ref=&Functions::OpenData($_sessid);
$idx=0;
@new=();
$a_total=0;

foreach $line(@{$ref}){
	$flag=0;
	$ctref=&Functions::SplitCart($line);
	foreach $n_line(@goodsnum){
		if($FORM{$n_line}=~/\D/){
			&error("個数は数字を入力してください。");
		}
		$n_line_d=$n_line;
		$n_line_d =~s/\+/ /g;
		$n_line_d=~s/%([0-9A-Fa-f][0-9A-Fa-f])/pack("C", hex($1))/eg;
		$n_line_d=~s/^mdfy_//;
		$num_d=${$ctref}{'number'}.${$ctref}{'op'};
		if($num_d eq $n_line_d){
			if(${$ctref}{'amount'} != $FORM{$n_line}){
				if($FORM{$n_line} == 0){
 					$flag=1;
					last;
				}
				else{
					if(${$ctref}{'stock'} ne ""){
						if(${$ctref}{'stock'} < $FORM{$n_line} && $CF::zaiko){
							&error("${$ctref}{'name'}の個数が在庫数より多くなっています。${$ctref}{'name'}の在庫数は${$ctref}{'stock'}です。","b");
						}
					}
					${$ctref}{'amount'}=$FORM{$n_line};
					$line=&Functions::MakeLine(\@CF::keys_cart,$ctref);
				}
  			}
		}
	}
	if(!$flag){
		$new[$idx]=$line;
		$idx++;
		$a_total+=${$ctref}{'amount'};
	}
}


$cook="";
foreach(@new){
	$cook.=$_."\n";
}

&Functions::WriteData($_sessid,$cook);
&Functions::SetCookie($a_total,"cart","root","","","");

&Top(\@new,$_sessid);

}


sub GetPage{
my($page);

if($FORM{'mode'} eq "regist"){
	$page=$FORM{'page'};
}
else{
	if($COOKIE{'page'}){
		$COOKIE{'page'}=~s/\+/ /g;
		$COOKIE{'page'}=~s/%([0-9A-Fa-f][0-9A-Fa-f])/pack("C", hex($1))/eg;
	}
	$page=$COOKIE{'page'};
}

return $page;
}



sub Enter{
my($_sessid,$ref,$skinline,$head,$dummy,$goods,$footer,$O_PCHS,$tmp);
my($name,$name2,$kana,$kana2,$postal,$pref,$address,$address2,$tel,$email,$email2);
my($payline,$n,$ck,$deliline,$dline,$v);

$_sessid=&Functions::GetSessId;
$ref=&Functions::OpenData($_sessid);

unless(open(HTML, $CF::enter)){
	&error("enterが開けません。ファイル名を確認してください。");
}
$skinline = join('',<HTML>);
close(HTML);

($head,$dummy) = split(/<!--goods-->/, $skinline);
if($head eq ""){
	&error("enterに&lt;!--goods--&gt;が書かれていません。");
}
($goods,$footer) = split(/<!--\/goods-->/, $dummy);
if($goods eq ""){
	&error("enterに&lt;!--goods--&gt;が書かれていません。");
}

$O_PCHS=&CartMain('enter',\$goods,\$footer,$ref);

$tmp=$COOKIE{$CF::angoc_name};

if($tmp){
	if($CF::pd eq ""){
		&error("パスワードが設定されていません。");
	}
	$tmp=&Cipher("de",$tmp);
	
	($name,$name2,$kana,$kana2,$postal,$pref,$address,$address2,$tel,$email,$email2)=split(/,/,$tmp);
	
	$footer=~s/#name2/$name2/;
	$footer=~s/#name/$name/;
	$footer=~s/#kana2/$kana2/;
	$footer=~s/#kana/$kana/;
	$footer=~s/#email2/$email/;
	$footer=~s/#email/$email/;
	$footer=~s/#postal/$postal/;
	$footer=~s/#address2/$address2/;
	$footer=~s/#address/$address/;
	$footer=~s/#tel/$tel/;
	$footer=~s/value="$pref"/value="$pref" selected/;
}
else{
	$footer=~s/#name2//;
	$footer=~s/#name//;
	$footer=~s/#kana2//;
	$footer=~s/#kana//;
	$footer=~s/#postal//;
	$footer=~s/#address2//;
	$footer=~s/#address//;
	$footer=~s/#tel//;
	$footer=~s/#email2//;
	$footer=~s/#email//;

}

$payline="";
$n=@CF::pay;
foreach(@CF::pay){
	if($n == 1){
		$ck=" checked";
	}
	else{
		if($_ eq $CF::paycheck){
			$ck=" checked";
		}
		else{
			$ck="";
		}
	}
	$payline.="<input type=\"radio\" name=\"pay\" value=\"$_\"$ck>$_ ";
}

$footer=~s/<!--pay-->/$payline/;


$deliline="";
$n=@CF::deliver;
if($n == 1 && $CF::deliver_show){
	$dline="<input type=\"hidden\" name=\"deliver\" value=\"$CF::deliver[0]\">";
	$footer=~s/<!--delitmp-->/$dline/;

}
else{
	foreach(@CF::deliver){
		$v=$_;
		$ck="";
		if($n == 1){
			$ck=" checked";
		}
		else{
			if($CF::delivercheck && $_ eq $CF::delivercheck){
				$ck=" checked";
			}
		}
		$deliline.="<input type=\"radio\" name=\"deliver\" value=\"$_\"$ck>$v ";
	}
}


$footer=~s/<!--deliver-->/$deliline/;

print "Content-type: text/html\n\n";
print $head;
print $O_PCHS->{'g_line'};
print $footer;

exit;

}


sub Confirm{
my($tmp,$_sessid,$ref,$skinline,$head,$dummy,$goods,$footer);
my($O_PCHS,$m_tmp,$tb,$info);

$err="";
if($FORM{'name'} eq ""){
	$err.='お名前が入力されていません。<br>';
}
if($FORM{'kana'} eq ""){
	$err.='フリガナが入力されていません。<br>';
}
if($FORM{'postal'} eq ""){
	$err.='郵便番号が入力されていません。<br>';
}
if($FORM{'pref'} eq ""){
	$err.='ご住所の都道府県が選択されていません。<br>';
}
if($FORM{'address'} eq ""){
	$err.='ご住所が入力されていません。<br>';
}

if($FORM{'tel'} eq ""){
	$err.='お電話番号が入力されていません。<br>';
}
if($FORM{'email'} eq ""){
	$err.='メールアドレスが入力されていません。<br>';
}
if($FORM{'email'} !~ /^([a-zA-Z0-9\.\-\/_]{1,})@([a-zA-Z0-9\.\-\/_]{1,})\.([a-zA-Z0-9\.\-\/_]{1,})$/){
	$err.='メールアドレスが正しくありません。全角で入力されていないか等確認してください。<br>';
}
if($FORM{'haisou'}){
	if($FORM{'name_rcpt'} eq ""){
		$err.='お届け先のお名前が入力されていません。<br>';
	}
	if($FORM{'kana_rcpt'} eq ""){
		$err.='お届け先のフリガナが入力されていません。<br>';
	}
	if($FORM{'postal_rcpt'} eq ""){
		$err.='お届け先の郵便番号が入力されていません。<br>';
	}
	if($FORM{'pref_rcpt'} eq ""){
		$err.='お届け先のご住所の都道府県が選択されていません。<br>';
	}
	if($FORM{'address_rcpt'} eq ""){
		$err.='お届け先のご住所が入力されていません。<br>';
	}
	if($FORM{'tel_rcpt'} eq ""){
		$err.='お届け先の電話番号が入力されていません。<br>';
	}
}


if($err){
	&error($err)
}

$_sessid=&Functions::GetSessId;
$ref=&Functions::OpenData($_sessid);

unless(open(HTML, $CF::confirm)){
	&error("confirmが開けません。ファイル名を確認してください。");
}
$skinline = join('',<HTML>);
close(HTML);

($head,$dummy) = split(/<!--goods-->/, $skinline);
if($head eq ""){
	&error("confirmに&lt;!--goods--&gt;が書かれていません。");
}

($goods,$footer) = split(/<!--\/goods-->/, $dummy);
if($goods eq ""){
	&error("confirmに&lt;!--/goods--&gt;が書かれていません。");
}


$O_PCHS=&CartMain('confirm',\$goods,\$footer,$ref);

$footer =~ s/<!--tax-->/$O_PCHS->{'tax_c'}/;
$footer =~ s/<!--total-->/$O_PCHS->{'total_c'}/;
$footer =~ s/<!--dai-->/$O_PCHS->{'dai_name'}/;
$footer =~ s/<!--charge-->/$O_PCHS->{'dai_charge_c'}/;
$footer =~ s/<!--name-->/$FORM{'name'}/;
$footer =~ s/<!--name2-->/$FORM{'name2'}/;
$footer =~ s/<!--kana-->/$FORM{'kana'}/;
$footer =~ s/<!--kana2-->/$FORM{'kana2'}/;
$footer =~ s/<!--postal-->/$FORM{'postal'}/;
$footer =~ s/<!--pref-->/$FORM{'pref'}/;
$footer =~ s/<!--address-->/$FORM{'address'}/;
$footer =~ s/<!--address2-->/$FORM{'address2'}/;
$footer =~ s/<!--email-->/$FORM{'email'}/;
$footer =~ s/<!--tel-->/$FORM{'tel'}/;
$footer =~ s/<!--pay-->/$FORM{'pay'}/;
$footer =~ s/<!--deliver-->/$FORM{'deliver'}/;

if($FORM{'deliver_day'} eq "on"){
	$footer =~ s/<!--date-->/$FORM{'month'}月$FORM{'day'}日/;
}
else{
	$footer =~ s/<!--date-->/指定しない/;
}
if($FORM{'deliver_time'} eq "on"){
	$footer =~ s/<!--time-->/$FORM{'time'}/;
}
else{
	$footer =~ s/<!--time-->/指定しない/;
}
if($FORM{'comment'}){
	$m_tmp=$FORM{'comment'};
	$m_tmp=~s/\n/<br>/g;
	$footer =~ s/<!--comment-->/$m_tmp/;
}


if($FORM{'name_rcpt'}){
	$footer =~ s/<!--name_rcpt-->/$FORM{'name_rcpt'}/;
	$footer =~ s/<!--name2_rcpt-->/$FORM{'name2_rcpt'}/;
	$footer =~ s/<!--kana_rcpt-->/$FORM{'kana_rcpt'}/;
	$footer =~ s/<!--kana2_rcpt-->/$FORM{'kana2_rcpt'}/;
	$footer =~ s/<!--postal_rcpt-->/$FORM{'postal_rcpt'}/;
	$footer =~ s/<!--pref_rcpt-->/$FORM{'pref_rcpt'}/;
	$footer =~ s/<!--address_rcpt-->/$FORM{'address_rcpt'}/;
	$footer =~ s/<!--address2_rcpt-->/$FORM{'address2_rcpt'}/;
	$footer =~ s/<!--tel_rcpt-->/$FORM{'tel_rcpt'}/;
}
else{
	$tb='<div class="onaji">お客様情報と同じ</div>';
	$footer=~s/<!--rcpt-->.*<!--\/rcpt-->/$tb/si;
}

$info="";
$info.=qq(<input type="hidden" name="sessid" value="$FORM{'sessid'}">\n);
$info.=qq(<input type="hidden" name="name" value="$FORM{'name'}">\n);
$info.=qq(<input type="hidden" name="name2" value="$FORM{'name2'}">\n);
$info.=qq(<input type="hidden" name="kana" value="$FORM{'kana'}">\n);
$info.=qq(<input type="hidden" name="kana2" value="$FORM{'kana2'}">\n);
$info.=qq(<input type="hidden" name="postal" value="$FORM{'postal'}">\n);
$info.=qq(<input type="hidden" name="pref" value="$FORM{'pref'}">\n);
$info.=qq(<input type="hidden" name="address" value="$FORM{'address'}">\n);
$info.=qq(<input type="hidden" name="address2" value="$FORM{'address2'}">\n);
$info.=qq(<input type="hidden" name="tel" value="$FORM{'tel'}">\n);
$info.=qq(<input type="hidden" name="email" value="$FORM{'email'}">\n);
$info.=qq(<input type="hidden" name="email2" value="$FORM{'email2'}">\n);
$info.=qq(<input type="hidden" name="pay" value="$FORM{'pay'}">\n);
$info.=qq(<input type="hidden" name="deliver" value="$FORM{'deliver'}">\n);
$info.=qq(<input type="hidden" name="wrapping" value="$FORM{'wrapping'}">\n);
$info.=qq(<input type="hidden" name="postage" value="$postage_all">\n);
$info.=qq(<input type="hidden" name="cookie" value="$FORM{'cookie'}">\n);
$info.=qq(<input type="hidden" name="mel" value="$FORM{'mel'}">\n);
$info.=qq(<input type="hidden" name="pass" value="$FORM{'pass'}">\n);
$info.=qq(<input type="hidden" name="point" value="$FORM{'point'}">\n);
$info.=qq(<input type="hidden" name="pointnum" value="$FORM{'pointnum'}">\n);

if($FORM{'name_rcpt'}){
	$info.=qq(<input type="hidden" name="name_rcpt" value="$FORM{'name_rcpt'}">\n);
	$info.=qq(<input type="hidden" name="name2_rcpt" value="$FORM{'name2_rcpt'}">\n);
	$info.=qq(<input type="hidden" name="kana_rcpt" value="$FORM{'kana_rcpt'}">\n);
	$info.=qq(<input type="hidden" name="kana2_rcpt" value="$FORM{'kana2_rcpt'}">\n);
	$info.=qq(<input type="hidden" name="postal_rcpt" value="$FORM{'postal_rcpt'}">\n);
	$info.=qq(<input type="hidden" name="pref_rcpt" value="$FORM{'pref_rcpt'}">\n);
	$info.=qq(<input type="hidden" name="address_rcpt" value="$FORM{'address_rcpt'}">\n);
	$info.=qq(<input type="hidden" name="address2_rcpt" value="$FORM{'address_rcpt'}">\n);
	$info.=qq(<input type="hidden" name="tel_rcpt" value="$FORM{'tel_rcpt'}">\n);
}

if($FORM{'deliver_day'} eq "on"){
	$info.=qq(<input type="hidden" name="date" value="$FORM{'month'}月$FORM{'day'}日">\n);
}

if($FORM{'deliver_time'} eq "on"){
	$info.=qq(<input type="hidden" name="time" value="$FORM{'time'}">\n);
}

$info.=qq(<input type="hidden" name="comment" value="$FORM{'comment'}">\n);

$footer =~ s/<!--info-->/$info/;


print "Content-type: text/html\n\n";
print $head;
print $O_PCHS->{'g_line'};
print $footer;

exit;

}


sub Order{
my($date,$date_d,$time_d,$odrID,$id);
my($_sessid,$ref,$O_PCHS,$mailbody,$chk_mailbody,$infoline);


($date,$date_d,$time_d)=&Functions::GetDate;

$odrID=&Functions::GetId;

if($CF::id_filename){
	$CF::csvfile=$odrID;
}
if($CF::id_title){
	$CF::rcpt_mailsub.=" ".$odrID;
}

if($CF::id){
	$id="ご注文番号: $odrID\n";
}
else{
	$id="";
}

$_sessid=&Functions::GetSessId;
$ref=&Functions::OpenData($_sessid);

if(!scalar(@{$ref})){
	&error("商品がありません。");
}

$O_PCHS=&CartMain('order',"",\$footer,$ref);

$mailbody=<<EOM;

============================================================
ご注文番号  : $odrID
ご注文日時  : $date_d $time_d
============================================================
EOM


$mailbody.=<<EOM;

■ご注文品
------------------------------------------------------------
$O_PCHS->{'goods_all'}
EOM


if($O_PCHS->{'zei_old'}){
$mailbody.=<<EOM;
$O_PCHS->{'zei_old'}％商品合計 :  $O_PCHS->{'subtotal_old_c'}
${CF::taxrate}％商品合計 :  $O_PCHS->{'subtotal_new_c'}
EOM
}

$mailbody.=<<EOM;
小計        :  $O_PCHS->{'subtotal_o_c'}
EOM

if($CF::waribiki){
$mailbody.=<<EOM;
割引        :  -$O_PCHS->{'wari_c'}
EOM
}

if($CF::waribiki){
$mailbody.=<<EOM;
小計(割引後):  $O_PCHS->{'subtotal_c'}
EOM
}

if($O_PCHS->{'zei_old'}){
$mailbody.=<<EOM;
($O_PCHS->{'zei_old'}％消費税) :  $O_PCHS->{'tax_old_c'}
(${CF::taxrate}％消費税) :  $O_PCHS->{'tax_new_c'}
EOM
}


$mailbody.=<<EOM;
(消費税合計):  $O_PCHS->{'tax_all_c'}
送料        :  $O_PCHS->{'postage_all_c'}
EOM

if($CF::dai_count_on && $O_PCHS->{'dai_charge'}){
$mailbody.=<<EOM;
$O_PCHS->{'dai_name'}手数料 :  $O_PCHS->{'dai_charge_c'}
EOM
}

if($FORM{'wrapping'} eq "yes"){
$mailbody.=<<EOM;
ラッピング  :  $O_PCHS->{'wrap_charge_c'}
EOM
}

$mailbody.=<<EOM;
----------------------------
合計        :  $O_PCHS->{'total_c'}
EOM


$mailbody.=<<EOM;

■ご注文者
お名前      :  $FORM{'name'} $FORM{'name2'}
フリガナ    :  $FORM{'kana'} $FORM{'kana2'}
郵便番号    :  $FORM{'postal'}
ご住所      :  $FORM{'pref'}$FORM{'address'}$FORM{'address2'}
お電話番号  :  $FORM{'tel'}
E-メール    :  $FORM{'email'}
EOM


if($FORM{'name_rcpt'}){
$mailbody.=<<"EOM";

■お届け先
お名前      :  $FORM{'name_rcpt'} $FORM{'name2_rcpt'}
フリガナ    :  $FORM{'kana_rcpt'} $FORM{'kana2_rcpt'}
郵便番号    :  $FORM{'postal_rcpt'}
ご住所      :  $FORM{'pref_rcpt'}$FORM{'address_rcpt'}$FORM{'address2_rcpt'}
お電話番号  :  $FORM{'tel_rcpt'}
EOM
}
else{
$mailbody.=<<"EOM";

■お届け先
※ご注文者と同じ
EOM
}


$mailbody.=<<EOM;

■お支払い方法・配送方法
お支払い方法 :  $FORM{'pay'}
配送方法     :  $FORM{'deliver'}
EOM

if($FORM{'date'}){
$mailbody.=<<EOM;
希望配達日   :  $FORM{'date'}
EOM
}

if($FORM{'time'}){
$mailbody.=<<EOM;
希望配達時間 :  $FORM{'time'}
EOM
}

if($FORM{'wrapping'} eq "yes"){
$mailbody.=<<EOM;
ラッピング    :  あり
EOM
}


$mailbody.=<<EOM;

■要望など
$FORM{'comment'}
EOM


if($CF::tenp_pay){
	if($FORM{'pay'} eq '銀行振込'){
		$mailbody.=$CF::paymsg_bank;
	}
	elsif($FORM{'pay'} eq '代金引換'){
		$mailbody.=$CF::paymsg_dai;
	}
	elsif($FORM{'pay'} eq 'eコレクト'){
		$mailbody.=$CF::paymsg_e;
	}
}



$CF::email_header="$FORM{'name'}  様\n\n".$CF::email_header;

$chk_mailbody=$CF::email_header.$mailbody.$CF::email_footer;

$mailbody.="\n";
$mailbody.="IP address : $ENV{'REMOTE_ADDR'}\n";
$mailbody.="Host      : $ENV{'REMOTE_HOST'}\n";
$mailbody.="User Agent: $ENV{'HTTP_USER_AGENT'}\n";


if($CF::zaiko){
	&Functions::filelock($CF::lockfile);
	&After($ref);
	&Functions::unlock;
}

unless(-e $CF::mailpl){
	&error("lib/mail.plがありません。");
}
require $CF::mailpl;

&S_Mail($CF::mailto,$FORM{'email'},$FORM{'name'},$CF::rcpt_mailsub,$mailbody,"shop",$ref,$odrID,$O_PCHS->{'a_total'},$O_PCHS->{'subtotal'},$O_PCHS->{'tax_all'},$O_PCHS->{'total'},$date_d,$time_d);
&S_Mail($FORM{'email'},$CF::mailto,$CF::shop,$CF::chk_mailsub,$chk_mailbody,"","");
if($CF::mailto2){
	&S_Mail($CF::mailto2,$FORM{'email'},$FORM{'name'},$CF::rcpt_mailsub,$mailbody,"shop",$ref);
}

&Functions::CookieDel($CF::c_name,"");
&Functions::CookieDel("page","");
&Functions::SetCookie("0","cart","root","","","");

&LogClear($_sessid);

if($FORM{'cookie'} eq "on"){
	if($CF::pd eq ""){
		&error("パスワードが設定されていません。");
	}
	$infoline="$FORM{'name'},$FORM{'name2'},$FORM{'kana'},$FORM{'kana2'},$FORM{'postal'},$FORM{'pref'},$FORM{'address'},$FORM{'address2'},$FORM{'tel'},$FORM{'email'}";
	$infoline=&Cipher("en",$infoline);
	&Functions::SetCookie($infoline,$CF::angoc_name,"","","time",$CF::c_valid);
}


&Thanks($FORM{'pay'},$odrID,$O_PCHS->{'goods_all_kessai'},$O_PCHS->{'total'},"$FORM{'name'}$FORM{'name2'}",$FORM{'tel'},$FORM{'email'});

}



sub After{
my($ref,$idx,$dum);
my($no,$name,$price,$image,$postage,$weight,$pack,$page,$amount,$no_s,$no_w,$cool,$stock,$opt,$opst);
my($ln,$ctref,@opst_a,$n,$opline1,$opline2,@o1,@o2,$flag,$k,$v,$s,@o,@new,$optmp);

$ref=$_[0];
$idx=0;
unless(open(FILE,$CF::g_log)){
	&error("g_logが開けません。");
}
@new=();
while(<FILE>){
	($no,$name,$price,$image,$postage,$weight,$pack,$page,$amount,$no_s,$no_w,$cool,$stock,$opt,$opst)=split(/,/,$_);
	foreach $ln(@{$ref}){
		$ctref=&Functions::SplitCart($ln);
		if($no eq ${$ctref}{'number'}){
			if($opt eq ""){
				if($stock == 0){
					&error("大変申し訳ありません。${$ctref}{'name'}は先に注文があり、在庫切れになりました。下のリンクよりお戻りになり、商品を削除して再度ご注文ください。","b");
				}
				if(${$ctref}{'amount'} > $stock){
					&error("大変申し訳ありません。${$ctref}{'name'}はただいまご注文があり、ご注文数より在庫が少なくなりました。現在の在庫数は$stockです。個数を変更して再度ご注文ください。","b");
				}
				$stock-=${$ctref}{'amount'};
				if($stock < 0){
					$stock=0;
				}
			}
			else{
				$opst.=":d";
				@opst_a=split(/:/,$opst);
				pop @opst_a;
				@opt_a=split(/<>/,$opt);
				$n=@opt_a;
				$opline1=$opt_a[0];
				$opline2=$opt_a[1];
				if($opline1=~/\//){
					($dum,$opline1)=split(/\//,$opline1);
				}
				if($opline2=~/\//){
					($dum,$opline2)=split(/\//,$opline2);
				}
				if($n==2){
					@o1=();
					if($opline1){
						$opline1.=":d";
						@o1=split(/:/,$opline1);
						pop @o1;
					}
					@o2=();
					if($opline2){
						$opline2.=":d";
						@o2=split(/:/,$opline2);
						pop @o2;
					}
					$k=0;
					$flag=0;
					foreach $v(@o1){
						foreach $l(@o2){
							$s=$v.":".$l;
							if($s eq ${$ctref}{'op'}){
								$flag=1;
								last;
							}
							$k++;
						}
						if($flag){
							last;
						}
					}
					if(($k <= $#opst_a) && ($opst_a[$k] ne "")){
						$optmp=${$ctref}{'op'};
						$optmp=~s/:/ /;
						if($opst_a[$k] == 0){
							&error("大変申し訳ありません。${$ctref}{'name'}の$optmpは先に注文がありました。下のリンクよりお戻りになり、商品を削除して、再度ご注文ください","modify");
						}
						if(${$ctref}{'amount'} > $opst_a[$k]){
							&error("申し訳ございませんが、${$ctref}{'name'}の$optmpはただ今注文があり、ご注文数より在庫が少なくなりました。現在の在庫数は$opst_a[$k]です。商品を削除して、再度ご注文ください","modify");
						}
						$opst_a[$k]-=${$ctref}{'amount'};
						if($opst_a[$k]<0){
							$opst_a[$k]=0;
						}
					}
					$opst=join(":",@opst_a);
				}
				elsif($n==1){
					@o=();
					if($opline1){
						$opline1.=":d";
						@o=split(/:/,$opline1);
						pop @o;
					}
					$k=0;
					foreach $v(@o){
						if($v eq ${$ctref}{'op'}){
							last;
						}
						$k++;
					}
					if(($k <= $#opst_a) && ($opst_a[$k] ne "")){
						if($opst_a[$k] == 0){
							&error("大変申し訳ありません。${$ctref}{'name'}の${$ctref}{'op'}は先に注文がありました。商品を削除して、再度ご注文ください","modify");
						}
						if(${$ctref}{'amount'} > $opst_a[$k]){
							&error("申し訳ございませんが、${$ctref}{'name'}の${$ctref}{'op'}はただ今注文があり、ご注文数より在庫が少なくなりました。現在の在庫数は$opst_a[$k]です。商品を削除して、再度ご注文ください","modify");
						}
						$opst_a[$k]-=${$ctref}{'amount'};
						if($opst_a[$k]<0){
							$opst_a[$k]=0;
						}
					}
					$opst=join(":",@opst_a);
				}
			}
			$_="$no,$name,$price,$image,$postage,$weight,$pack,$page,$amount,$no_s,$no_w,$cool,$stock,$opt,$opst,\n";
		}
	}
	$new[$idx]=$_;
	$idx++;

}
close FILE;

unless(open(FILE,">$CF::g_log")){
	&error("g_logが開けません。")
}
print FILE @new;
close FILE;

&MakeJs(\@new);

}

sub MakeJs{
my($ref,@op,@opst,$tmp,$i,@o,$v,$oline1,$oline2,@o1,@o2,$l,$t);
my($no,$name,$price,$image,$postage,$weight,$pack,$page,$amount,$no_s,$no_w,$cool,$stock,$op,$opst);

$ref=$_[0];

unless(open(FILE,">$CF::jslog")){
	&error("jslogが開けません。");
}
print FILE "var st=new Array();\n";
foreach(@{$ref}){
	($no,$name,$price,$image,$postage,$weight,$pack,$page,$amount,$no_s,$no_w,$cool,$stock,$op,$opst)=split(/,/,$_);
	if(($op ne "") || ($opst ne "")){
		@op=split(/<>/,$op);
		@opst=split(/:/,$opst);
		$tmp="";
		$tmp.="st['$no']=new Array()\;\n";
		$i=0;
		if(@op == 1){
			@o=split(/:/,$op);
			foreach $v(@o){
				$tmp.="st['$no']['$v']='$opst[$i]'\;\n";
				$i++;
			}
		}
		elsif(@op == 2){
			@o=split(/<>/,$op);
			$oline1=$o[0];
			$oline2=$o[1];
			$oline1.=':d';
			$oline2.=':d';
			@o1=split(/:/,$oline1);
			@o2=split(/:/,$oline2);
			pop @o1;
			pop @o2;
			$i=0;
			foreach $l(@o1){
				foreach $v(@o2){
					$t="$l $v";
					if($opst[$i] ne ""){
						$tmp.="st['$no']['$t']='$opst[$i]'\;\n";
					}
					$i++;

				}
			}
		}
	}
	else{
		$tmp="st['$no']='$stock'\;\n";
	}
	print FILE $tmp;
}

close FILE;


}


sub LogClear{
my($now,$bango,@files,$file,$time);
$now=time;
$bango=$_[0];

unless(opendir(DIR,$CF::tmpdir)){
	&error("tmpdirが開けません。");
}

@files=readdir DIR;
closedir DIR;



foreach(@files){
	if(($_ ne '.') && ($_ ne '..')){
		$file=$CF::tmpdir.$_;
		$time=(stat($file))[9];
		if(($now-$time) > 24*60*60){
			if(-e $file){
				unless(unlink($file)){
					&error("$fileが削除できません。");
				}
			}
		}
	}
}

$file=$CF::tmpdir.$bango;

if(-e $file){
	unless(unlink($file)){
		&error("fileが削除できません。");
	}
}


}


sub Cipher{
my($act,$data,$len,$len_p,@ran,$j,$i,$tmp,$d,$tmp_p,$d_p,$dum,$r,$result,$sal);

$act=$_[0];
$data=$_[1];

if($act eq "de"){
	$data=pack("H*",$data);
}

$len=length($data);
$len_p=length($CF::pd);

$sal=0;
for($i=0;$i<$len_p;$i++){
	$tmp_p=substr($CF::pd,$i,1);
	$sal+=unpack("C",$tmp_p);
}
srand($sal);
$sal=int(rand(10000));

srand($sal);

for($i=0;$i<$len_p;$i++){
	$ran[$i]=int(rand(127));
}

$j=0;
for($i=0;$i<$len;$i++){
	$tmp=substr($data,$i,1);
	$d=unpack("C",$tmp);
	$tmp_p=substr($CF::pd,$j,1);
	$d_p=unpack("C",$tmp_p);
	$dum=$d_p ^ $ran[$j];
	$r=$d ^ $dum;
	$result.=pack("C",$r);
	$j++;
	if($j >= $len_p){
		$j=0;
	}
}

if($act eq "en"){
	$result=unpack("H*",$result);
}

return $result;
}


sub Thanks{
my($pay,$odrID,$goods_all_kessai,$total,$name,$tel,$email);
my(@goods,$line,$tmpline,$skinline,$kessai,$form);

$pay=$_[0];
$odrID=$_[1];
$goods_all_kessai=$_[2];
$total=$_[3];
$name=$_[4];
$tel=$_[5];
$email=$_[6];

$goods_all_kessai=~s/:$//;
@goods=split(/:/,$goods_all_kessai);
$tmpline="";
$line="";
foreach(@goods){
	$tmpline.=$_;
	if(length($tmpline) >= 170){
		$line.="...";
		last;
	}
	$line=$tmpline;
}

$line=~s/ $//;

unless(open(HTML, $CF::thanks)){
	&error("thanksが開けません。ファイル名を確認してください。");
}
$skinline = join('',<HTML>);
close(HTML);
if($id){
	$skinline =~ s/<!--id-->/お客様のご注文番号は$odrIDです。<br>/;
}

if($pay eq 'クロネコWebコレクト'){
$form=<<EOM;
<form action="https://payment.kuronekoyamato.co.jp/kuroneko/servlet/YCS_ServletC" method="post" target="_blank" style="margin-top:20px">
<input type="hidden" name="TRS_MAP" value="L_TEST">
<input type="hidden" name="trader_code" value="$CF::trader_code">
<input type="hidden" name="order_no" value="$odrID">
<input type="hidden" name="goods_name" value="$line">
<input type="hidden" name="settle_price" value="$total">
<input type="hidden" name="buyer_name_kanji" value="$name">
<input type="hidden" name="buyer_tel" value="$tel">
<input type="hidden" name="buyer_email" value="$email">
<div class="center">
<input type="submit" value="クロネコWEBコレクトでの決済はこちら">
</div>
</form>
EOM

	$skinline=~s/<!--kessai-->/$form/;
	$skinline=encode('sjis',decode('utf8',$skinline));
	$skinline=~s/utf-8/Shift_JIS/i;
}

print <<EOM;
Content-type: text/html

EOM

print $skinline;

exit;
}


sub error{

if($lockflag==1){
	close LOCK;
}

print "Content-type: text/html\n\n";

print <<EOM;
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<title></title>
<style type="text/css">
p,div{
	text-aling:center
}
</style>
</head>
<body>
<h3>ERROR</h3>
EOM

print"<p>※$_[0]</p>\n";

if($_[1] eq "b"){
	print qq(<p><a href="cart.cgi?mode=view">カート画面で変更</a></p>);
}
elsif($_[1] eq "c"){
	print qq(<p><a href="#" onclick="history.back()">商品画面に戻る</a></p>);
}
else{
	if($_[1] ne "r"){
		print qq(<p>ブラウザの戻るボタンでお戻りください。</p>);
	}
}

print <<EOM;
</body>
</html>
EOM
exit;
}

exit;
