const chars=['あ','い','う','え','お','か','き','く','け','こ','さ','し','す','せ','そ','た','ち','つ','て','と','な','に','ぬ','ね','の','は','ひ','ふ','へ','ほ','ま','み','む','め','も','や','ゆ','よ','ら','り','る','れ','ろ','わ','を','ん'];
function Captcha() {
	let ans="";
	let ans_ary=[];
	for (let i = 0; i <= 3; i++) {
		let idx = Math.floor(Math.random()*chars.length);
		ans+=chars[idx];
		ans_ary.push(chars[idx]);
	}

	const key = hex_md5(ans);
	document.getElementById('key').value=key;


	const canvasWinth = 110;
	const canvasHeight = 30;
	let canvas = document.getElementById('captcha');
	let context = canvas.getContext('2d');
	canvas.width = canvasWinth;
	canvas.height = canvasHeight;

	for (let i = 0; i <= 3; i++) {
		let deg = (Math.random()*10*Math.PI)/180;
		let txt = ans_ary[i];
		let x = 10 + i*20;
		let y = 20 + Math.random()*8;
		context.font = "normal 23px 'MS PGothic',sans-serif";
		context.translate(x, y);
		context.rotate(deg);

		context.fillStyle = MakeColor();
		context.fillText(txt, 0, 0);

		context.rotate(-deg);
		context.translate(-x, -y);
	}


	for (let i = 0; i <= 5; i++) {
		context.strokeStyle = MakeColor();
		context.beginPath();
		context.moveTo(Math.random() * canvasWinth, Math.random() * canvasHeight);
		context.lineTo(Math.random() * canvasWinth, Math.random() * canvasHeight);
		context.stroke();
	}
	
	for (let i = 0; i < 30; i++) {
		context.strokeStyle = MakeColor();
		context.beginPath();
		let x = Math.random() * canvasWinth;
		let y = Math.random() * canvasHeight;
		context.moveTo(x,y);
		context.lineTo(x+1, y+1);
		context.stroke();
	}
}

function MakeColor () {
	let r = Math.floor(Math.random()*230);
	let g = Math.floor(Math.random()*230);
	let b = Math.floor(Math.random()*230);
	return 'rgb(' + r + ',' + g + ',' + b + ')';
}

Captcha();