<?php

error_reporting(E_ALL & ~E_NOTICE & ~E_WARNING & ~E_DEPRECATED);

//設置の仕方、カスタマイズの仕方などはreadme.txtをごらんください。

//-------------- 基本設定-------------------

$mailto='xxx@xxx.xxx';			//メールを受け取る人(あなた)のメールアドレス

$sama='1';				//$email_style1の文のうえに(送り主)様をつける 1:つける 0:つけない
$chk_mailsub='確認メール';		//メール送信者に送られる確認メールの件名を設定
$kanri='あなたかサイトの名前';		//確認メールの送信者に表示する名前

$check_mail='0';			//確認メールを送るか(1:送る 0:送らない)

$email_header=<<<EOM
メールありがとうございます。

EOM;

$email_footer=<<<EOM

---------------------------
hoge@ne.jp
http://hoge.ne.jp
---------------------------
EOM;

//確認メールの前後に表示するメッセージを記入します。前の文は$email_headerに、後の文は$email_footerに記入
//不要なときは
//$email_style1=<<<'EOM'
//EOM
//のようにつめること


$mailsub='メールフォームより';		//受け取るメールの件名
$capt='0';				//文字の入力(CAPTCHA)を行うか(1:行う 0:行わない)
$confirm='1';				//確認画面を表示するか(1:表示する 0:表示しない)

//-------------- ここから下は変更の必要なし------------

$name_dummy='送信者';			//名前の入力がない場合に代用する文字列

$html_form='form.html';
$html_confirm='confirm.html';	//確認画面のスキン
$html_thanks='thanks.html';	//終了画面のHTML
$html_error='error.html';	//エラー画面のHTML
$sendmail='/usr/sbin/sendmail';	//sendmailのパス サーバーのマニュアルで調べて記入

$upimgdir='./tmp/';		//確認用に一時的に画像をアップするディレクトリ

$UPOK=array(
'jpg'=>'1',
'gif'=>'1',
'png'=>'1',
'pdf'=>'1',
'xls'=>'1',
'xlsx'=>'1',
'doc'=>'1',
'ppt'=>'1',
);

//アップロード可能ファイル('拡張子'=>'1か0' アップ可能にするときは1 禁止のときは0)

$maxsize=10000000;

//------------ 設定はここまで。--------------


$o_func=new Func;
$o_main=new Main;

$fo=$o_func->ParseInt();

if($fo['mode'] == "confirm" && !$confirm){
	$fo['mode']="send";
}

switch($fo['mode']){
	case "confirm":
		$o_main->Confirm($fo);
		break;
	case "send":
		$o_main->Send($fo);
		break;
	default:
		$o_main->Form($fo,array());
		break;
}


Class Main{

function Form($fo,$e){
global $html_form;
global $capt;

$fp=@fopen($html_form,'r');
if(!$fp){
	 self::Error("fileが開けません。");
}
$skinline="";
while($ln=fgets($fp)){
	$skinline.=$ln;
}
fclose($fp);


if(count($e)){
	$js="<script>\n";
	$js.="const hissu={\n";
	foreach($e as $n=>$v){
		$js.="'".$n."':[";
		$ajs="";
		foreach($v as $l){
			$ajs.="'".$l."',\n";
		}
		$ajs=rtrim($ajs,"\n");
		$ajs=rtrim($ajs,",");
		$js.=$ajs;
		
		$js.="],\n";

	}
	$js=rtrim($js,"\n");
	$js=rtrim($js,",");
	$js.="}\n";
	$ex=array("mode","require","for_name","for_title","for_email","key","ans","imgorder");

	$js.="const inputs={\n";
	foreach($fo as $n=>$v){
		if(in_array($n,$ex)){
			continue;
		}
		if(is_array($v)){
			$n.="[]";
		}
		$js.="'".$n."':";
		if(is_array($v)){
			$js.="[";
			$ajs="";
			foreach($v as $l){
				$ajs.="'".$l."',\n";
			}
			$ajs=rtrim($ajs,"\n");
			$ajs=rtrim($ajs,",");
			$js.=$ajs;
			$js.="],\n";
		}
		else{
			$v=str_replace("\r\n","\\n",$v);
			$v=str_replace("\r","\\n",$v);
			$js.="'".$v."',\n";
		}
	}
	$js=rtrim($js,"\n");
	$js=rtrim($js,",");
	$js.="}\n";

	$js.="window.addEventListener('load',Check);\n";
	$js.="window.addEventListener('load',Input);\n";
	$js.="</script>\n";

	$skinline=str_replace("<!--js-->",$js,$skinline);
}

if(!$capt){
	$skinline=preg_replace("/<!--capt-->.*?<!--\/capt-->/s","",$skinline,1);
}

header("Content-type: text/html");
print $skinline;
exit;

}

function Check($fo){
global $capt;
global $o_func;


$email=$fo[$fo['for_email']];
$name=$fo[$fo['for_name']];

if($email){
	if(preg_match("/,/",$email) || preg_match("/;/",$email)){
		self::Error("メールアドレスが不適切です。");
	}
	if(strlen($email) > 100){
		self::Error("メールアドレスが不適切です。");
	}
}

if($fo[$fo['for_title']]){
	$title=$fo[$fo['for_title']];
}

$require=explode(",",$fo['require']);

$e=array();
foreach($require as $l){
	$l_d=str_replace('[]',"",$l);
	if(!$fo[$l_d]){
		if(!isset($e[$l])){
			$e[$l]=array();
		}
		array_push($e[$l],"{$l_d}を入力してください。");
	}
}

if($email){
	if(!preg_match("/^[a-zA-Z0-9\.\-_]+@[a-zA-Z0-9\.\-_]+$/",$email)){
		if(!isset($e[$fo['for_email']])){
			$e[$fo['for_email']]=array();
		}
		array_push($e[$fo['for_email']],"メールアドレスが正しくありません。");
	}
}

if($capt){
	if($fo['ans'] == ""){
		if(!isset($e['ans'])){
			$e['ans']=array();
		}
		array_push($e['ans'],"文字を入力してください。");
	}
	else{
		$re=$o_func->CheckAns($fo['key'],$fo['ans']);
		if(!$re){
			if(!isset($e['ans'])){
				$e['ans']=array();
			}
			array_push($e['ans'],"認証できません。");
		}
	}
}


if(count($e)){
	self::Form($fo,$e);
}

return array($email,$name,$title);


}

function GetData(&$fo){

$ex=array("mode","require","for_name","for_title","for_email","key","ans","imgs","imgorder");

$data=array();
foreach($fo as $name => $value){
	if(!in_array($name,$ex) && $value){
		$data[$name]=$value;
	}
}

return $data;
}

function MakeJS(&$data){
$js=json_encode($data,JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);
return $js;
}

function ImgTag(&$data,$imgs,$imgorder,$act){
global $upimgdir;

$imgtmp=array();
foreach($imgs as $n=>$v){
	$img=$imgs[$n]['filename'];
	$value=$imgs[$n]['upfname'];
	$ext_a=explode('.',$img);
	$ext=strtolower($ext_a[count($ext_a)-1]);
	$imgfilename=$upimgdir.$img;
	if(file_exists($imgfilename)){
		if($act == "send"){
			$value=$value;
		}
		else{
			if($ext == "gif" || $ext == "jpg" || $ext == "png"){
				$size=@getimagesize($imgfilename);
				$w=$size[0];
				$h=$size[1];
				$value="<img src=\"{$upimgdir}{$img}\" width=\"{$w}\" height=\"{$h}\">";
			}
		}
	}
	$imgtmp[$n]=$value;
}

$tmp=array();
$flag=false;
foreach($data as $nn=>$vv){
	$tmp[$nn]=$vv;
	if(!$flag && $nn == $imgorder){
		foreach($imgtmp as $n=>$v){
			$tmp[$n]=$v;
		}
		$flag=true;
	}
}

if(!$flag){
	foreach($imgtmp as $n=>$v){
		$tmp[$n]=$v;
	}
}


return $tmp;



}


function Confirm($fo){
global $html_confirm;
global $upimgdir;
global $o_func;

self::Check($fo);

$imgs=$o_func->Upload();
$data=self::GetData($fo);
if(count($imgs)){
	$imgjs=self::MakeJS($imgs);
	$imgjs=str_replace('"',"&quot;",$imgjs);
	$data=self::ImgTag($data,$imgs,$fo['imgorder'],"confirm");
}
else{
	$imgjs="";
}

$fp=@fopen($html_confirm,'r');
if(!$fp){
	self::Error("skinが開けません。");
}
while($ln=fgets($fp)){
	$skinline.=$ln;
}
fclose($fp);

list($head,$dummy) = explode("<!--row-->",$skinline);

if($dummy == ""){
	self::Error("スキンに&lt;!--row--&gt;が書かれていません。");
}

list($tr,$footer) = explode("<!--/row-->",$dummy);
if($footer == ""){
	self::Error("スキンに&lt;!--/row--&gt;が書かれていません。");
}

foreach($data as $n=>$v){
	$tr_d=$tr;
	if(is_array($v)){
		$v=join(" ",$v);
	}
	$v=str_replace("\r\n","<br>",$v);
	$v=str_replace("\n","<br>",$v);

	$tr_d=str_replace("<!--name-->",$n,$tr_d);
	$tr_d=str_replace("<!--value-->",$v,$tr_d);
	$showline.=$tr_d;

}

$input="";
foreach($fo as $n=>$v){
	if($n == "mode"){
		continue;
	}
	if(is_array($v)){
		foreach($v as $vv){
			$input.="<input type=\"hidden\" name=\"{$n}[]\" value=\"{$vv}\">\n";
		}
	}
	else{
		$input.="<input type=\"hidden\" name=\"{$n}\" value=\"{$v}\">\n";
	}
}
$input.="<input type=\"hidden\" name=\"imgs\" value=\"{$imgjs}\">\n";


$footer=str_replace("<!--input-->",$input,$footer);

print $head;
print $showline;
print $footer;
exit;

}

function Send($fo){
global $sama;
global $email_style1;
global $mailto;
global $chk_mailsub;
global $email_style2;
global $kanri;
global $mailsub;
global $check;
global $upimgdir;
global $checkmail;
global $mailto2;
global $o_func;
global $confirm;
global $name_dummy;


list($email,$name,$title)=self::Check($fo);

$data=self::GetData($fo);

if(!$confirm){
	$imgs=$o_func->Upload();
}
else{
	if($fo['imgs']){
		$fo['imgs']=str_replace('&quot;','"',$fo['imgs']);
		$imgs=json_decode($fo['imgs'],true);
		if(!$imgs){
			self::Error("JSONデータがデコードできません。");
		}
	}
}

if($imgs && count($imgs)){
	$data=self::ImgTag($data,$imgs,$fo['imgorder'],"send");
}


if(!$mailsub){
	self::Error("mailsubが設定されていません。");
}
if(!$name_dummy){
	self::Error("name_dummyが設定されていません。");
}
if(!$mailto){
	self::Error("mailtoが設定されていません。");
}

if(!$title){
	$title=$mailsub;
}
if(!$name){
	$name=$name_dummy;
}
if(!$email){
	$email=$mailto;
}

foreach($data as $n=>$v){
	if(is_array($v)){
		$v=join(" ",$v);
	}

	$v=str_replace('&#39;',"'",$v);
	$v=str_replace('&quot;','"',$v);
	$v=str_replace('&gt;','>',$v);
	$v=str_replace('&lt;','<',$v);
	$v=str_replace('&amp;','&',$v);
	$v=str_replace("\r\n","\n",$v);
	
	$mailbody.=$n.": ".$v."\n";
}

if($sama){
	$email_style1="$name 様\n\n".$email_style1;
}

$chk_mailbody=$email_style1.$mailbody.$email_style2;

$o_func->S_Mail($mailto,$email,$name,$title,$mailbody,'kanri',$imgs);

if($checkmail){
	$o_func->S_Mail($email,$mailto,$kanri,$chk_mailsub,$chk_mailbody,"",imgs);
}

if($mailto2){
	$o_func->S_Mail($mailto2,$email,$name,$title,$mailbody,'kanri',$imgs);
}

self::Clean();
self::Thanks();
}

function Clean(){
global $upimgdir;
$dir=@opendir($upimgdir);
if(!$dir){
	 self::Error("{$upimgdir}が開けません。");
}
while($f=readdir($dir)){
	if($f != "." && $f != ".."){
		$files[]=$f;
	}
}
closedir($dir);
$now=time();
$limit=60*60*24;
if(is_array($files)){
	foreach($files as $v){
		$file=$upimgdir.$v;
		$mtime=filemtime($file);
		if ($mtime < ($now - $limit)) {
			if(!unlink($file)){
				self::Error("{$file}が削除できません。");
			}
		}
	}
}
}
function Thanks(){
global $html_thanks;
$fp=@fopen($html_thanks,'r');
if(!$fp){
	 self::Error("{$file}が開けません。");
}
while($ln=fgets($fp)){
	print $ln;
}
fclose($fp);
exit;
}


function Error($e){
global $html_error;

$fp=@fopen($html_error,'r');
if(!$fp){
	$ob->dmyerror("{$html_error}が開けません。");
}
$skinline="";
while($ln=fgets($fp)){
	$skinline.=$ln;
}
fclose($fp);

$skinline=str_replace("<!--error-->",$e,$skinline);
print $skinline;
exit;
}

function dmyerror($e){
print "<html><body>$e</body></html>\n";
exit;
}

}//Class End

Class Func{

function ParseInt(){
global $upimgdir;
global $maxsize;

if($_SERVER['REQUEST_METHOD'] == 'POST'){
	$ary=&$_POST;
}
else{
	$ary=&$_GET;
}

$in=array();

foreach($ary as $name => $value){
	$name=str_replace('&','',$name);
	$name=str_replace('<','',$name);
	$name=str_replace('>','',$name);
	$name=str_replace('"','',$name);
	$name=str_replace("'",'',$name);

	$value=str_replace('&','&amp;',$value);
	$value=str_replace('<','&lt;',$value);
	$value=str_replace('>','&gt;',$value);
	$value=str_replace('"','&quot;',$value);
	$value=str_replace("'",'&#39;',$value);
	
	$value=str_replace('&amp;amp;','&amp;',$value);
	$value=str_replace('&amp;lt;','&lt;',$value);
	$value=str_replace('&amp;gt;','&gt;',$value);
	$value=str_replace('&amp;quot;','&quot;',$value);
	$value=str_replace('&amp;#39;','&#39;',$value);

	$in[$name]=$value;
}

return $in;
}


function S_Mail($to,$from,$fromname,$sub,$mailbody,$act,$imgs){
global $sendmail;
global $check;
global $upimgdir;
global $o_main;

if($fromname){
	$fromname=mb_encode_mimeheader(mb_convert_encoding($fromname,"JIS","UTF-8"),"JIS");
	$fromname="$fromname <$from>";
}
else{
	$fromname=$from;
}
if($sub){
	$sub=mb_encode_mimeheader(mb_convert_encoding($sub,"JIS","UTF-8"),"JIS");
}

$mailbody=mb_convert_encoding($mailbody,"JIS","UTF-8");
$m=popen("$sendmail -t -i", "w");
fputs($m,"To: $to\n");
fputs($m,"From: $fromname\n");
fputs($m,"Subject: $sub\n");
fputs($m,"MIME-Version: 1.0\n");

if($act == 'kanri' && $imgs && count($imgs)){
	fputs($m,"Content-Type: multipart/mixed; boundary=\"kugiri\"\n\n");
	fputs($m,"--kugiri\n");
}
fputs($m,"Content-Type: text/plain; charset=\"ISO-2022-JP\"\n");
fputs($m,"Content-Transfer-Encoding: 7bit\n\n");
fputs($m,"$mailbody\n");
if($act == 'kanri' && $imgs && count($imgs)){
	$i=0;
	$k=0;
	foreach($imgs as $n=>$v){
		$filename=$v['filename'];
		$cont=$v['cont'];
		$fname=$v['upfname'];
		$i++;
		$img="img$i";
		
		$file=$upimgdir.$filename;
		$fp=fopen($file,'rb');
		if(!$fp){
			$o_main->Error("{$file}ファイルが開けません。");
		}
		$tmp=fread($fp,filesize($file));
		if(!$tmp){
			$o_main->Error("ファイルが読み込めません。");
		}
		fclose($fp);

		if(file_exists($file)){
			if(!unlink($file)){
				$o_main->Error("{$file}が削除できません。");
			}
		}
		if(!$cont){
			$o_main->Error("content typeがありません。");
		}
		if(!$fname){
			$o_main->Error("ファイル名がありません。");
		}
		
		$tmp=chunk_split(base64_encode($tmp));
		fputs($m,"--kugiri\n");
		fputs($m,"Content-Type: $cont; name=\"$fname\"\n");
		fputs($m,"Content-Transfer-Encoding: base64\n");
		fputs($m,"Content-Disposition: attachment; filename=\"$fname\"\n\n");
		fputs($m,$tmp);
		fputs($m,"\n\n");
		
		$k++;
	}
	fputs($m,"--kugiri--\n");
}
pclose($m);
}

function Upload(){
global $maxsize;
global $upimgdir;
global $o_main;

$imgs=array();
$imgcount=0;
foreach($_FILES as $key => $hash){
	$s=$_FILES[$key]['size'];
	$n=$_FILES[$key]['name'];
	$t=$_FILES[$key]['type'];
	$tm=$_FILES[$key]['tmp_name'];
	if($n){
		if($s > $maxsize){
			$o_main->Error("投稿のサイズが大きすぎます。");
		}
		$ext=self::FileType($t);
		if(!$ext){
			$o_main->error("アップロードできないファイル形式です。");
		}
		if($_FILES[$key]['error']){
			$o_main->Error("{$key}のアップロードに失敗しました。");
		}
		$imgcount++;
		$sessid=self::MakeSess();
		$imgfile=$sessid.$imgcount.time().getmypid().'.'.$ext;
		$imgfilename = $upimgdir.$imgfile;
		if(!move_uploaded_file($tm,$imgfilename)){
			$o_main->Error("アップロードに失敗しました。");
		}

		$imgs[$key]['filename']=$imgfile;
		$imgs[$key]['cont']=$t;

		$n=str_replace('&','&amp;',$n);
		$n=str_replace('<','',$n);
		$n=str_replace('>','',$n);
		$n=str_replace('"','',$n);
		$n=str_replace("'",'&#39;',$n);
		$n=str_replace('[','',$n);
		$n=str_replace("]",'',$n);
		$imgs[$key]['upfname']=$n;
	}
}
return $imgs;
}

function FileType($t){
global $UPOK;

if($t == ""){
	return;
}

$type=array(
'image/jpeg'=>'jpg',
'image/gif'=>'gif',
'image/png'=>'gif',
'application/pdf'=>'pdf',
'application/msword'=>'doc',
'application/vnd.ms-excel'=>'xls',
'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'=>'xlsx',
'application/vnd.ms-powerpoint'=>'ppt',
);

if(!$type[$t]){
	return;
}

$tt=$type[$t];

if(!$UPOK[$tt]){
	return;
}
return $tt;
}
function MakeSess(){
$saltset=array('a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z',
'A','B','D','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z',
'1','2','3','4','5','6','7','8','9','0');
$count=count($saltset)-1;
srand(time()^getmypid());

$newcode.=$saltset[rand(0,$count)];
$newcode.=$saltset[rand(0,$count)];
$newcode.=$saltset[rand(0,$count)];
$newcode.=$saltset[rand(0,$count)];
$newcode.=$saltset[rand(0,$count)];
$newcode.=$saltset[rand(0,$count)];
$newcode.=$saltset[rand(0,$count)];
$newcode.=$saltset[rand(0,$count)];

return($newcode);
}
function GetHost(){
$ip=$_SERVER['REMOTE_ADDR'];
$host=$_SERVER['REMOTE_HOST'];

if($host == ""){
	$host=gethostbyaddr($ip);
}
if($host){
	$ho=$host;
}
else{
	$ho=$ip;
}
return $ho;
}

function CheckAns($key,$ans){

$coded=md5($ans);

$flag=false;

if($coded == $key){
	$flag=true;
}

return $flag;
}


}//Class End


exit;

?>
