#!/usr/bin/perl

#↑Perlのパス サーバーのマニュアルをみて確認する

use Encode;
use MIME::Base64;

#設置の仕方、カスタマイズの仕方などはreadme.txtをごらんください。

#-------------- 基本設定-------------------

$mailto='xxx@xxx.xxx';		#メールを受け取る人(あなた)のメールアドレス
$mailto2='';			#メールをもう一つ送るときは''に記入

$checkmail='1';			#確認メールを送るか1:送る0:送らない

$email_style1=<<'EOM';
メールありがとうございます。

EOM

$email_style2=<<'EOM';

---------------------------
hoge@ne.jp
http://hoge.ne.jp
---------------------------
EOM

#確認メールの前後に表示するメッセージを記入します。前の文は$email_style1に、後の文は$email_style2に記入
#いらないときは
#$email_style1=<<'EOM';
#EOM
#のようにつめること

$sama='1';				#$email_style1の文のうえに(送り主)様をつける 1:つける 0:つけない
$chk_mailsub='確認メール';		#メール送信者に送られる確認メールの件名を設定
$chk_mailname='サイトの名前';		#確認メールの送信者に表示する名前

#---------------- ここから下は変更の必要なし ---------------

$mailsub='';

$html_chk='check.html';		#確認画面のスキン
$html_thanks='thanks.html';	#終了画面のHTML
$html_error='error.html';	#エラー画面のHTML

$sendmail='/usr/sbin/sendmail';	#sendmailのパス サーバーのマニュアルで調べて記入

$maxsize=100000;		#投稿量の限度(バイト) 日本語は1文字2バイトです。

#------------ 設定はここまで。--------------

if($ENV{'REQUEST_METHOD'} eq "POST"){
	if($ENV{'CONTENT_LENGTH'}>$maxsize){
		&error("投稿量が多すぎます。");
	}
	read(STDIN,$buff,$ENV{'CONTENT_LENGTH'});
}
else{
	$buff=$ENV{'QUERY_STRING'};
}
if($buff){
	&Dec;
}

sub Dec{
	my(@pairs,$pair,$value,$name,$forflag,@LINE,$flag,$flag2);
	@pairs=split(/&/,$buff);
	foreach $pair (@pairs){
		($name,$value)=split(/=/,$pair);
		$value=~tr/+/ /;
		$value=~s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
		$value=~s/&/!amp;/g;
		$value=~s/</!lt;/g;
		$value=~s/>/!gt;/g;
		$value=~s/"/!quot;/g;
		$value=~s/'/!#039;/g;
		$name=~tr/+/ /;
		$name=~s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
		$name=~s/&//g;
		$name=~s/<//g;
		$name=~s/>//g;
		$name=~s/"//g;
		$name=~s/'//g;
		if($name eq "mode" || $name eq "fukusu" || $name eq "data" || $name eq 'require'){
			$FORM{$name}=$value;
		}
		elsif($name=~/^for_/){
			$FOR{$name}=$value;
		}
		else{
			$flag=0;
			foreach(@NAME){
				if($_ eq $name){
					$flag=1;
					last;
				}
			}
			if($flag){
				$flag2=0;
				foreach(@FUKUSU){
					if($_ eq $name){
						$flag2=1;
					}
				}
				if(!$flag2){
					push @FUKUSU,$name;
				}
				if($DATA{$name}){
					$DATA{$name}.='_!a_'.$value;
				}
			}
			else{
				push @NAME,$name;
				$DATA{$name}=$value;
			}
		}

	}

}


if($FORM{'mode'} eq "send"){
	&Send;
}
elsif($FORM{'mode'} eq "check"){
	&Check;
}

sub Check{
my($skinline,$head,$dummy,$tr,$footer,@require,$email,$err,
$l,$flag,$tr_d,$fflag,$v,$value,$input,$showline,$fukusu,$data,@keys,@tmp
);

unless(open(HTML, $html_chk)){
	&error("$html_chkが開けません。ファイルを確認してください。");
}
$skinline=join('',<HTML>);
close(HTML);

($head,$dummy)=split(/<!--start-->/,$skinline);
if($head eq ""){
	&error("$html_chkに<!--start-->が書かれていません。");
}
($tr,$footer)=split(/<!--end-->/,$dummy);
if($tr eq ""){
	&error("$html_chkに<!--end-->が書かれていません。");
}

@require=split(/,/,$FORM{'require'});
$email=$DATA{$FOR{'for_email'}};
$err="";

foreach $l(@require){
	$flag=0;
	if(!$DATA{$l}){
		$flag=1;

	}
	if($flag){
		$err.="$lが入力されていません。<br>";
	}
}

if($email){
	if($email !~ /^([a-zA-Z0-9\.\-\/_]{1,})@([a-zA-Z0-9\.\-\/_]{1,})\.([a-zA-Z0-9\.\-\/_]{1,})$/){
		$err.="メールアドレスが正しくありません。全角で入力されていないか等確認してください。";
	}
}

if($err){
	&error($err);
}

foreach $l(@NAME){
	$tr_d=$tr;
	$fflag=0;
	foreach $v(@FUKUSU){
		if($l eq $v){
			$fflag=1;
		}
	}
	$value=$DATA{$l};
	$value=~s/\x0D\x0A/\n/g;
	$value=~s/\x0D/\n/g;
	$value=~s/\x0A/\n/g;
	$input.=qq(<input type="hidden" name="$l" value="$value">\n);

	if($fflag){
		@tmp=split(/_!a_/,$value);
		$value=join(' ',@tmp);
	}

	$value=~s/\n/<br>/g;
	$value=~s/!amp;/&amp;/g;
	$value=~s/!lt;/&lt;/g;
	$value=~s/!gt;/&gt;/g;
	$value=~s/!quot;/&quot;/g;
	$value=~s/!#039;/&#039;/g;
	$tr_d =~ s/<!--name-->/$l/;
	$tr_d =~ s/<!--value-->/$value/;
	$showline.=$tr_d;

}

$fukusu=join('_!_',@FUKUSU);
$data=join('_!_',@NAME);

$input.="<input type=\"hidden\" name=\"fukusu\" value=\"$fukusu\">\n";
$input.="<input type=\"hidden\" name=\"data\" value=\"$data\">\n";

@keys=keys %FOR;

foreach(@keys){
	$input.="<input type=\"hidden\" name=\"$_\" value=\"$FOR{$_}\">\n";
}

$footer =~ s/<!--input-->/$input/;

print "Content-type: text/html\n\n";
print $head;
print $showline;
print $footer;
exit;


}

sub End{
unless(open(HTML,$html_thanks)){
	&error("$html_thanksが開けません。ファイルを確認してください。");
}

print "Content-type: text/html\n\n";
while(<HTML>){
	print $_;
}
close HTML;
exit;
}

sub Send{
my($email,$name,$title,@na,@fukusu,$l,$v,$value,$fflag,
$chk_mailbody,$mailbody,@tmp,$host
);

$email=$DATA{$FOR{'for_email'}};
$name=$DATA{$FOR{'for_name'}};
if($mailsub){
	$title=$mailsub;
}
elsif($DATA{$FOR{'for_title'}}){
	$title=$DATA{$FOR{'for_title'}};
}
else{
	$title='タイトル未設定';
}

if($email eq ""){
	&error("メールアドレスがありません。");
}
if(length($email) >100){
	&error("メールアドレスが不適切です。");
}
if($email=~/,/){
	&error("メールアドレスが不適切です。");
}
if($email=~/\n/){
	&error("メールアドレスが不適切です。");
}
if($email !~ /^([a-zA-Z0-9\.\-\/_]{1,})@([a-zA-Z0-9\.\-\/_]{1,})\.([a-zA-Z0-9\.\-\/_]{1,})$/){
	&error("メールアドレスが正しくありません。全角で入力されていないか等確認してください。");
}
if($title=~/\n/){
	&error("タイトルが不適切です。");
}
if($name=~/\n/){
	&error("名前が不適切です。");
}


@na=split(/_!_/,$FORM{'data'});
@fukusu=split(/_!_/,$FORM{'fukusu'});

foreach $l(@na){
	$fflag=0;
	foreach $v(@fukusu){
		if($l eq $v){
			$fflag=1;
		}
	}
	$value=$DATA{$l};

	$value=~s/\x0D\x0A/\n/g;
	$value=~s/\x0D/\n/g;
	$value=~s/\x0A/\n/g;

	$value=~s/!amp;/&/g;
	$value=~s/!quot;/"/g;
	$value=~s/!#039;/'/g;
	$value=~s/!lt;/</g;
	$value=~s/!gt;/>/g;

	if($fflag){
		@tmp=split(/_!a_/,$value);
		$value=join(' ',@tmp);
	}
	$mailbody.=$l.": ".$value."\n";
}

if($sama){
	$email_style1="$name 様\n\n".$email_style1;
}

$chk_mailbody=$email_style1.$mailbody.$email_style2;

$host=&GetHost;
$mailbody.="\n";
$mailbody.="IP address: $ENV{'REMOTE_ADDR'}\n";
$mailbody.="Host      : $host\n";
$mailbody.="User Agent: $ENV{'HTTP_USER_AGENT'}\n";


&S_Mail($mailto,$email,$name,$title,$mailbody);
if($checkmail){
	&S_Mail($email,$mailto,$chk_mailname,$chk_mailsub,$chk_mailbody);
}
if($mailto2){
	&S_Mail($mailto2,$email,$name,$title,$mailbody);
}

&End;
}

sub GetHost{
my($addr,$ho);
$ho=$ENV{'REMOTE_HOST'};
$addr=$ENV{'REMOTE_ADDR'};
if($ho eq "" || $host eq $addr){
	$ho=gethostbyaddr(pack("C4", split(/\./, $addr)),2) || $addr;
}

return $ho;
}


sub S_Mail{
my($to,$from,$fromname,$sub,$mailbody);
$to=$_[0];
$from=$_[1];
$fromname=$_[2];
$sub=$_[3];
$mailbody=$_[4];


if($fromname){
	$fromname=encode('jis',decode('utf8',$fromname));
	$fromname=&mail64encode($fromname);
	$fromname="$fromname <$from>";
}
else{
	$fromname=$from;
}
if($sub){
	$sub=encode('jis',decode('utf8',$sub));
	$sub=&mail64encode($sub);
}


$mailbody=encode('jis',decode('utf8',$mailbody),Encode::FB_XMLCREF);

$mailbody=~s/\e\(B&#xff5e;\e\$B/\e\$B\x21\x41/g;
$mailbody=~s/\e\(B&#xff5e;/\e\$B\x21\x41\e\(B/g;
$mailbody=~s/&#xff5e;\e\$B/\e\$B\x21\x41/g;
$mailbody=~s/&#xff5e;/\e\$B\x21\x41\e\(B/g;

$mailbody=~s/\e\(B&#xff0d;\e\$B/\e\$B\x21\x3e/g;
$mailbody=~s/\e\(B&#xff0d;/\e\$B\x21\x3e\e\(B/g;
$mailbody=~s/&#xff0d;\e\$B/\e\$B\x21\x3e/g;
$mailbody=~s/&#xff0d;/\e\$B\x21\x3e\e\(B/g;

if(!open(MAIL, "| $sendmail -t -i")){
	&error("メール送信できません。sendmailのパス等を確認してください。");
}
print MAIL "To: $to\n";
print MAIL "From: $fromname\n";
print MAIL "Subject: $sub\n";
print MAIL "MIME-Version: 1.0\n";
print MAIL "Content-Type: text/plain; charset=\"ISO-2022-JP\"\n";
print MAIL "Content-Transfer-Encoding: 7bit\n\n";
print MAIL "$mailbody\n";
close(MAIL);
}


sub mail64encode {
my($tmp_bun) = $_[0];
$tmp_bun = encode_base64($tmp_bun,"");
return("=?ISO-2022-JP?B?${tmp_bun}?=");
}


sub error{
my($err,$skinline);

$err=$_[0];
unless(open(HTML,$html_error)){
	&dmyerror("$_[0]$html_errorが開けません。ファイル名を確認してください。");
}
$skinline = join('',<HTML>);
close(HTML);

$skinline=~s/<!--error-->/$err/;

print "Content-type: text/html\n\n";
print $skinline;
exit;
}

sub dmyerror{

print "Content-type: text/html\n\n";
print "<html><body>$_[0]</body></html>";
exit;
}


exit;