#!/usr/bin/perl

#↑Perlのパス サーバーのマニュアルをみて確認する

use Encode;
use MIME::Base64;

#mail binary ver.4.1

#設置の仕方、カスタマイズの仕方などはreadme.txtをごらんください。

#-------------- 基本設定------------

$mailto='xxx@xxx.xxx';		#メールを受け取る人(あなた)のメールアドレス
$mailto2='';			#メールをもう一つ送るときは''に記入

$checkmail='1';			#確認メールを送るか 1:送る0:送らない

$email_style1=<<'EOM';
メールありがとうございます。

EOM

$email_style2=<<'EOM';

---------------------------
hoge@ne.jp
http://hoge.ne.jp
---------------------------
EOM

#確認メールの前後に表示するメッセージを記入します。前の文は$email_style1に、後の文は$email_style2に記入
#いらないときは
#$email_style1=<<'EOM';
#EOM
#のようにつめること

$sama='1';				#$email_style1の文のうえに(送り主)様をつける 1:つける 0:つけない
$chk_mailsub='確認メール';		#メール送信者に送られる確認メールの件名を設定
$chk_mailname='サイトの名前';		#確認メールの送信者に表示する名前


#-------------- 以下は基本的に変更の必要なし-------------------

$html_chk='check.html';		#確認画面のスキン
$html_thanks='thanks.html';	#終了画面のHTML
$html_error='error.html';	#エラー画面のHTML

$upimgdir='./tmp/';		#確認用に一時的に画像をアップするディレクトリ
$sendmail='/usr/sbin/sendmail';	#sendmailのパス
$mailsub='';

$komoku_f='画像';			#アップロードファイルの項目名('ファイル'、'写真'など。)

%UPOK=(
'jpg'=>'1',
'gif'=>'1',
'pdf'=>'1',
'doc'=>'1',
'xls'=>'1',
);

#アップロード可能ファイル('拡張子'=>'1か0' アップ可能にするときは1 禁止のときは0)

$maxsize=10000000;	#投稿量の限度(バイト) 日本語は1文字2バイトです。

#------------ 設定はここまで。--------------

@FUKUSU=();

if($ENV{'CONTENT_TYPE'} =~ /multipart\/form-data/){
	&DcdMulti;
}
else{
	&Dcd;
}

sub DcdMulti{
my($ref,$in_ref,$incfn_ref,$inct_ref,
$name,$value,
$o,$d,$upflag,$upnflag,$filename,$ctype,$okflag,
$csvfilename,$t_fname,$na,@tmp,$dum,$app,$ext,$imgfilename,$upidx,$imgcount,$upflag,$imgfile_n,
$sessid,$fukusu_ref,%count,
);

unless(-e "./cgi_lib_m.pl"){
	&error("cgi_lib_m.plがありません。");
}
require './cgi_lib_m.pl';

($ref,$in_ref,$incfn_ref,$inct_ref,$fukusu_ref)=&ReadParse;
@FUKUSU=@{$fukusu_ref};
@FUKUSU=grep(!$count{$_}++,@FUKUSU);

$upidx=0;
$imgcount=0;
foreach $name(@{$ref}){
	if ($name !~/^upfile/) {
		$value=${$in_ref}{$name};
		$value=~s/&/!amp;/g;
		$value=~s/</!lt;/g;
		$value=~s/>/!gt;/g;
		$value=~s/"/!quot;/g;
		$value=~s/'/!#039;/g;

		$name=~s/&//g;
		$name=~s/<//g;
		$name=~s/>//g;
		$name=~s/"//g;
		$name=~s/'//g;

		&InForm(\$name,\$value);

	}
	else{
		$upflag=0;
		$filename="";
		$ctype="";
		$okflag=0;
		$filename=${$incfn_ref}{$name};
		$ctype=${$inct_ref}{$name};
		$CTYPE{$name}=$ctype;

		if($filename){
			$ext=&FileType($ctype);

			if(!$ext){
				&error("アップロードできないファイル形式です。");
			}

			$filename=~s/\//\\/g;
    			@tmp=split(/\\/, $filename);
      			$imgfile_n=$tmp[$#tmp];
			if($imgfile_n=~/\n/ || $imgfile_n=~/"/ || $imgfile_n=~/'/ || $imgfile_n=~/</ || $imgfile_n=~/>/ || $imgfile_n=~/,/){
				&error('不適切なファイル名です。');
			}
			$sessid=&MakeSess;
			$imgcount++;
			$imgfile=$sessid.$imgcount.time.$$.'.'.$ext;
			$imgfilename = $upimgdir.$imgfile;
			$UPFNAME[$upidx]=$imgfile;
			$upidx++;
			unless(open(IMAGE,">$imgfilename")){
				&error("画像のアップロードに失敗しました");
			}
			binmode(IMAGE);
			binmode(STDOUT);
			print IMAGE ${$in_ref}{$name};
			close(IMAGE);
			$upflag=1;
			push @filename,$imgfile;
			push @cont_a,$ctype;
			push @upfname,$imgfile_n;
			$nm='ufile_'.$imgcount;
			push @NAME,$nm;
			$DATA{$nm}=$imgfile_n;
			$UP{$nm}=$imgfile;
		}
	}
}

}



sub Dcd{
my($name,$value,$buff,@pairs,$pair);

if($ENV{'REQUEST_METHOD'} eq "POST"){
	if($ENV{'CONTENT_LENGTH'} > $maxsize){
		&error("投稿量が多すぎます。");
	}
	read(STDIN,$buff,$ENV{'CONTENT_LENGTH'});
}
else{
	$buff=$ENV{'QUERY_STRING'};
}

if($buff){
	@pairs=split(/&/,$buff);
	foreach $pair(@pairs){
		($name,$value)=split(/=/,$pair);
		$value=~tr/+/ /;
		$value=~s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
		$value=~s/&/!amp;/g;
		$value=~s/</!lt;/g;
		$value=~s/>/!gt;/g;
		$value=~s/"/!quot;/g;
		$value=~s/'/!#039;/g;

		$name=~tr/+/ /;
		$name=~s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
		$name=~s/&//g;
		$name=~s/<//g;
		$name=~s/>//g;
		$name=~s/"//g;
		$name=~s/'//g;
		&InForm(\$name,\$value);
	}
}

}

sub FileType{
my(%type,$t,$tt,$dum);
$t=$_[0];

if($t eq ""){
	return;
}

($dum,$t)=split(/\//,$t);

%type=(
'pjpeg'=>'jpg',
'jpeg'=>'jpg',
'gif'=>'gif',
'pdf'=>'pdf',
'msword'=>'doc',
'vnd.ms-excel'=>'xls',
'x-shockwave-flash'=>'swf',
'avi'=>'avi',
);

if(!$type{$t}){
	return;
}

$tt=$type{$t};

if(!$UPOK{$tt}){
	return;
}

return $tt;
}

sub MakeSess{
my(@saltset,$newcode,$sal);
@saltset=('a'..'z','A'..'Z','0'..'9');
srand(time^$$);
$newcode.=$saltset[int(rand(@saltset))];
$newcode.=$saltset[int(rand(@saltset))];
$newcode.=$saltset[int(rand(@saltset))];
$newcode.=$saltset[int(rand(@saltset))];
$newcode.=$saltset[int(rand(@saltset))];
$newcode.=$saltset[int(rand(@saltset))];
$newcode.=$saltset[int(rand(@saltset))];
$newcode.=$saltset[int(rand(@saltset))];
$newcode.=$saltset[int(rand(@saltset))];
$newcode.=$saltset[int(rand(@saltset))];
$newcode.=$saltset[int(rand(@saltset))];
$newcode.=$saltset[int(rand(@saltset))];
return $newcode;
}

sub InForm{
my($ref_name,$ref_value);
$ref_name=$_[0];
$ref_value=$_[1];

if(${$ref_name} eq "mode" || ${$ref_name} eq "fukusu" || ${$ref_name} eq "data" || ${$ref_name} eq 'require' || ${$ref_name} eq 'filename' || ${$ref_name} eq 'cont_a' || ${$ref_name} eq 'upfname' || ${$ref_name}=~/^upfile/){
	$FORM{${$ref_name}}=${$ref_value};
}
elsif(${$ref_name}=~/^for_/){
	$FOR{${$ref_name}}=${$ref_value};
}
else{
	push @NAME,${$ref_name};
	$DATA{${$ref_name}}=${$ref_value};

}

}



if($FORM{'mode'} eq "send"){
	&Send;
}
elsif($FORM{'mode'} eq "check"){
	&Check;
}


sub Check{
my($skinline,$head,$dummy,$tr,$footer,@require,$email,$err,
$l,$flag,$tr_d,$fflag,$v,$value,$input,$showline,$fukusu,$data,@keys,@tmp,
@ext_a,$ext,$imgfilename,$w,$h,$wh,$fileline,$contline,$upimg,$dum,$n,$upline,$ln
);

unless(open(HTML, $html_chk)){
	&error("$html_chkが開けません。ファイルを確認してください。");
}
$skinline=join('',<HTML>);
close(HTML);

($head,$dummy)=split(/<!--start-->/,$skinline);
if($head eq ""){
	&error("$html_chkに<!--start-->が書かれていません。");
}
($tr,$footer)=split(/<!--end-->/,$dummy);
if($tr eq ""){
	&error("$html_chkに<!--end-->が書かれていません。");
}

@require=split(/,/,$FORM{'require'});
$email=$DATA{$FOR{'for_email'}};
$err="";

foreach $l(@require){
	$flag=0;
	if(!$DATA{$l}){
		$flag=1;

	}
	if($flag){
		$err.="$lが入力されていません。<br>";
	}
}

if($email){
	if($email !~ /^([a-zA-Z0-9\.\-\/_]{1,})@([a-zA-Z0-9\.\-\/_]{1,})\.([a-zA-Z0-9\.\-\/_]{1,})$/){
		$err.="メールアドレスが正しくありません。全角で入力されていないか等確認してください。";
	}
}

if($err){
	&error($err);
}

foreach $ln(@NAME){
	$l=$ln;
	$tr_d=$tr;
	$fflag=0;
	if($l=~/^ufile/){
		$upimg=$UP{$l};
		$value=$DATA{$l};
		@ext_a=split(/\./,$upimg);
		$ext=$ext_a[$#ext_a];
		$imgfilename=$upimgdir.$upimg;

		if(-e $imgfilename){
			$input.=qq(<input type="hidden" name="$l" value="$value">\n);
			if($ext eq "jpg" || $ext eq "JPG" || $ext eq "gif" || $ext eq "GIF"){
				($w,$h)=&GetSize($ext,$imgfilename);
				if($w && $h){
					$wh=" width=\"$w\" height=\"$h\"";
				}
				else{
					$wh="";
				}
				$value="<img src=\"$upimgdir$upimg\"$wh>";
			}
			else{
				$value="<a href=\"$upimgdir$upimg\">$value</a>";
			}

		}
		($dum,$n)=split(/_/,$l);
		$l=$komoku_f.$n;
	}
	else{
		foreach $v(@FUKUSU){
			if($l eq $v){
				$fflag=1;
			}
		}
		$value=$DATA{$l};
		$value=~s/\x0D\x0A/\n/g;
		$value=~s/\x0D/\n/g;
		$value=~s/\x0A/\n/g;
		$input.=qq(<input type="hidden" name="$l" value="$value">\n);
	
		if($fflag){
			@tmp=split(/_!a_/,$value);
			$value=join(' ',@tmp);
		}
	
		$value=~s/\n/<br>/g;

	}

	$tr_d =~ s/<!--name-->/$l/;

	$value=~s/!amp;/&amp;/g;
	$value=~s/!lt;/&lt;/g;
	$value=~s/!gt;/&gt;/g;
	$value=~s/!quot;/&quot;/g;
	$value=~s/!#039;/&#039;/g;

	$tr_d =~ s/<!--value-->/$value/;
	$showline.=$tr_d;

}

$fukusu=join('_!_',@FUKUSU);
$data=join('_!_',@NAME);


$input.="<input type=\"hidden\" name=\"fukusu\" value=\"$fukusu\">\n";
$input.="<input type=\"hidden\" name=\"data\" value=\"$data\">\n";

@keys=keys %FOR;

foreach(@keys){
	$input.="<input type=\"hidden\" name=\"$_\" value=\"$FOR{$_}\">\n";
}

if(scalar(@filename) != scalar(@cont_a)){
	&error('データの数が一致していません。');
}
if(scalar(@filename) != scalar(@upfname)){
	&error('データの数が一致していません。');
}


$fileline=join(",",@filename);
$contline=join(",",@cont_a);
$upline=join(",",@upfname);
$input.="<input type=\"hidden\" name=\"filename\" value=\"$fileline\">\n";
$input.="<input type=\"hidden\" name=\"cont_a\" value=\"$contline\">\n";
$input.="<input type=\"hidden\" name=\"upfname\" value=\"$upline\">\n";

$footer =~ s/<!--input-->/$input/;

print "Content-type: text/html\n\n";
print $head;
print $showline;
print $footer;
exit;


}

sub End{
unless(open(HTML,$html_thanks)){
	&error("$html_thanksが開けません。ファイルを確認してください。");
}

print "Content-type: text/html\n\n";
while(<HTML>){
	print $_;
}
close HTML;
exit;
}

sub Send{
my($email,$name,$title,@na,@fukusu,$l,$v,$value,$fflag,
$chk_mailbody,$mailbody,@tmp,@filename,@cont_a,$host,$dum,$n,@upfname,$ln
);

$email=$DATA{$FOR{'for_email'}};
$name=$DATA{$FOR{'for_name'}};
if($mailsub){
	$title=$mailsub;
}
elsif($DATA{$FOR{'for_title'}}){
	$title=$DATA{$FOR{'for_title'}};
}
else{
	$title='タイトル未設定';
}

if($email eq ""){
	&error("メールアドレスがありません。");
}
if(length($email) >100){
	&error("メールアドレスが不適切です。");
}
if($email=~/,/){
	&error("メールアドレスが不適切です。");
}
if($email=~/\n/){
	&error("メールアドレスが不適切です。");
}
if($email !~ /^([a-zA-Z0-9\.\-\/_]{1,})@([a-zA-Z0-9\.\-\/_]{1,})\.([a-zA-Z0-9\.\-\/_]{1,})$/){
	&error("メールアドレスが正しくありません。全角で入力されていないか等確認してください。");
}
if($title=~/\n/){
	&error("タイトルが不適切です。");
}
if($name=~/\n/){
	&error("名前が不適切です。");
}


@na=split(/_!_/,$FORM{'data'});
@fukusu=split(/_!_/,$FORM{'fukusu'});

foreach $ln(@na){
	$l=$ln;
	$fflag=0;
	$value=$DATA{$l};
	if($l=~/^ufile/){
		($dum,$n)=split(/_/,$l);
		$l=$komoku_f.$n;
	}
	else{
		foreach $v(@fukusu){
			if($l eq $v){
				$fflag=1;
			}
		}
		$value=~s/\x0D\x0A/\n/g;
		$value=~s/\x0D/\n/g;
		$value=~s/\x0A/\n/g;
		$value=~s/!amp;/&/g;
		$value=~s/!quot;/"/g;
		$value=~s/!#039;/'/g;
		$value=~s/!lt;/</g;
		$value=~s/!gt;/>/g;
		if($fflag){
			@tmp=split(/_!a_/,$value);
			$value=join(' ',@tmp);
		}
	}
	$mailbody.=$l.": ".$value."\n";
}

if($sama){
	$email_style1="$name 様\n\n".$email_style1;
}

$chk_mailbody=$email_style1.$mailbody.$email_style2;

$host=&GetHost;

$mailbody.="\n";
$mailbody.="IP address: $ENV{'REMOTE_ADDR'}\n";
$mailbody.="Host      : $host\n";
$mailbody.="User Agent: $ENV{'HTTP_USER_AGENT'}\n";

unless(-e './mimew.pl'){
	&error("mimew.plがありません。");
}

require './mimew.pl';

@filename=split(/,/,$FORM{'filename'});
@cont_a=split(/,/,$FORM{'cont_a'});
@upfname=split(/,/,$FORM{'upfname'});

if(scalar(@filename) != scalar(@cont_a)){
	&error('データの数が一致していません。');
}
if(scalar(@filename) != scalar(@upfname)){
	&error('データの数が一致していません。');
}

&S_Mail($mailto,$email,$name,$title,$mailbody,'shop',\@filename,\@cont_a,\@upfname);
if($checkmail){
	&S_Mail($email,$mailto,$chk_mailname,$chk_mailsub,$chk_mailbody);
}
if($mailto2){
	&S_Mail($mailto2,$email,$name,$title,$mailbody,'shop',\@filename,\@cont_a,\@upfname);
}
&Del(\@filename);
&Clean;
&End;
}

sub GetHost{
my($addr,$ho);
$ho=$ENV{'REMOTE_HOST'};
$addr=$ENV{'REMOTE_ADDR'};
if($ho eq "" || $host eq $addr){
	$ho=gethostbyaddr(pack("C4", split(/\./, $addr)),2) || $addr;
}

return $ho;
}

sub Del{
my($ref_filename,$file);

$ref_filename=$_[0];

foreach(@{$ref_filename}){
	$file=$upimgdir.$_;
	if(-e $file){
		unless(unlink($file)){
			&error("$fileが削除できません。");
		}
	}
}

}


sub Clean{
my($now,$limit,@files,$file,$mtime);
$now=time;
$limit=60*60*1;

unless(opendir(DIR, $upimgdir)){
	&error("$upimgdirが開けません。");
}
@files=readdir(DIR);
closedir(DIR);

foreach (@files){
	if($_ ne '.' && $_ ne '..'){
		$file=$upimgdir.$_;
		($mtime) = (stat($file))[9];
		if ($mtime < ($now - $limit)) {
			unless(unlink($file)){
				&error("$fileが削除できません。");
			}
		}
	}
}


}

sub S_Mail{
my($to,$from,$fromname,$sub,$mailbody,$ref_filename,$ref_cont_a,$i,$k,$len,$img,%IMG,$file,$fname,$act,$ref_upfname);
$to=$_[0];
$from=$_[1];
$fromname=$_[2];
$sub=$_[3];
$mailbody=$_[4];
$act=$_[5];
$ref_filename=$_[6];
$ref_cont_a=$_[7];
$ref_upfname=$_[8];

if($fromname){
	$fromname=encode('jis',decode('utf8',$fromname));
	$fromname=&mail64encode($fromname);
	$fromname="$fromname <$from>";
}
else{
	$fromname=$from;
}
if($sub){
	$sub=encode('jis',decode('utf8',$sub));
	$sub=&mail64encode($sub);
}

$mailbody=encode('jis',decode('utf8',$mailbody),Encode::FB_XMLCREF);

$mailbody=~s/\e\(B&#xff5e;\e\$B/\e\$B\x21\x41/g;
$mailbody=~s/\e\(B&#xff5e;/\e\$B\x21\x41\e\(B/g;
$mailbody=~s/&#xff5e;\e\$B/\e\$B\x21\x41/g;
$mailbody=~s/&#xff5e;/\e\$B\x21\x41\e\(B/g;

$mailbody=~s/\e\(B&#xff0d;\e\$B/\e\$B\x21\x3e/g;
$mailbody=~s/\e\(B&#xff0d;/\e\$B\x21\x3e\e\(B/g;
$mailbody=~s/&#xff0d;\e\$B/\e\$B\x21\x3e/g;
$mailbody=~s/&#xff0d;/\e\$B\x21\x3e\e\(B/g;


if(!open(MAIL, "| $sendmail -t -i")){
	&error("メール送信できません。sendmailのパス等を確認してください。");
}
print MAIL "To: $to\n";
print MAIL "From: $fromname\n";
print MAIL "Subject: $sub\n";
print MAIL "MIME-Version: 1.0\n";
if($act eq 'shop' && scalar(@{$ref_filename})){
	print MAIL "Content-Type: multipart/mixed\; boundary=\"kugiri\"\n\n";
	print MAIL "--kugiri\n";
}
print MAIL "Content-Type: text/plain; charset=\"ISO-2022-JP\"\n";
print MAIL "Content-Transfer-Encoding: 7bit\n\n";
print MAIL "$mailbody\n";
if($act eq 'shop' && scalar(@{$ref_filename})){
	$i=0;
	$k=0;
	foreach(@{$ref_filename}){
		$i++;
		$img="img$i";
		if($_){
			$fname=${$ref_upfname}[$k];
			if($fname eq ""){
				$fname=$_;
			}
			$file=$upimgdir.$_;
			unless(open(IMAGE,$file)){
				&error("$fileが開けません");
			}
			binmode(IMAGE);
			$len = -s IMAGE;
			read(IMAGE, $IMG{$img}, $len);
			close(IMAGE);
			$IMG{$img}=&bodyencode($IMG{$img},"b64");
			$IMG{$img}.=&benflush("b64");
			print MAIL "--kugiri\n";
			print MAIL "Content-Type: ${$ref_cont_a}[$k]\; name=\"$fname\"\n";
			print MAIL "Content-Transfer-Encoding: base64\n";
			print MAIL "Content-Disposition: attachment; filename=\"$fname\"\n\n";
			print MAIL $IMG{$img};
			print MAIL "\n";
			print MAIL "\n";
		}
		$k++;
	}
	print MAIL "--kugiri--\n";
}

close MAIL;

}


sub mail64encode {
my($tmp_bun) = $_[0];
$tmp_bun = encode_base64($tmp_bun,"");
return("=?ISO-2022-JP?B?${tmp_bun}?=");
}


sub GetSize{
my($fi,$ex,$w,$h,$size,$i,$mark,$code,$len);

$ex=$_[0];
$fi=$_[1];
$w=0;
$h=0;
if($ex eq "gif" || $ex eq "GIF"){
	unless(open(GIF,$fi)){
		return(0,0);
	}
	seek(GIF,6,0);
	if(read(GIF,$size,4)){
		($w,$h)=unpack("vv",$size);
	}
	close(GIF);
	return($w,$h);
}
elsif($ex eq "jpg" || $ex eq "JPG"){
	unless(open(JPEG,$fi)){
		return(0,0);
	}
	binmode JPEG;
	read(JPEG,$b,2);
	for($i=0;$i<10;$i++) {
		unless(read(JPEG,$b,4)){
			last;
		}
		($mark,$code,$len)=unpack("CCn",$b);
		if($mark != 0xFF){
			last;
		}
		elsif($code == 0xC0 || $code == 0xC2) {
      			if(read(JPEG,$b,5)){
     				($h,$w)=unpack("xnn",$b);
			}
     			last;
        	}
		else{
 			unless(read(JPEG,$b,($len-2))){
				last;
			}
		}

	}
    	close JPEG;
	return($w,$h);
}

}


sub error{
my($err,$act,$msg,$skinline);

$err=$_[0];

unless(open(HTML,$html_error)){
	&dmyerror("$_[0]$html_errorが開けません。ファイル名を確認してください。");
}
$skinline = join('',<HTML>);
close(HTML);

$skinline=~s/<!--error-->/$err/;

print "Content-type: text/html\n\n";
print $skinline;
exit;
}

sub dmyerror{

print "Content-type: text/html\n\n";
print "<html><body>$_[0]</body></html>";
exit;
}


exit;