<?php

error_reporting(E_ALL & ~E_NOTICE & ~E_WARNING & ~E_DEPRECATED);

//----ライブラリ読込み---------------

require('./lib/conf_common.php');
require('./lib/conf_fixed.php');
require('./lib/passwd.php');

$commonpl='./lib/conf_common.php';
$setpl='./lib/admin/set.php';
$roompl='./lib/admin/room.php';

#----------------------------------

$o_main=new Main;

$fo=$o_main->ParseInt();

if($fo['mode']){
	$o_main->CheckPass($fo);
}

list($lib,$mode)=explode('_',$fo['mode']);

switch($lib){
	case "room":
		if(!file_exists($roompl)){
			$o_main->Error("roomplがありません。");
		}
		include_once($roompl);
		$o_room=new Room();
		switch($mode){
			case "del":
				$o_room->Del($fo);
				break;
			case "regist":
				$o_room->Regist($fo);
				break;
			case "edit":
				$o_room->Edit($fo);
				break;
			case "editregist":
				$o_room->EditRegist($fo);
				break;
			case "position":
				$o_room->Position($fo);
				break;
			default:
				$o_room->Top($fo);
				break;
		}

	case "set":
		if(!file_exists($setpl)){
			$o_main->Error("setplがありません。");
		}
		include_once($setpl);
		$o_set=new Set();
		switch($mode){
			case "regist":
				$o_set->Regist($fo);
				break;
			default:
				$o_set->Top($fo,"","");
				break;
		}
	default:
		switch($fo['mode']){
			case "atop":
				$o_main->Atop($fo);
				break;
			default:
				$o_main->Ent($fo);
				break;
		}
}


Class Main{

function SetCookie($pass){
global $cookie_name;
global $cookie_hozon;
$cook=$pass;
setcookie($cookie_name,$cook,time()+$cookie_hozon*24*3600);
}

function DelCookie(){
global $cookie_name;
setcookie($cookie_name,'');
}

function GetCookie(){
global $cookie_name;

$cookies=$_SERVER['HTTP_COOKIE'];

$DUMMY=array();
$DUMMY[$cookie_name]="";
$pairs=explode(";",$cookies);
foreach($pairs as $p){
	list($name,$value)=explode("=",$p);
	$name=str_replace(" ","",$name);
	$DUMMY[$name]=$value;
}

$DUMMY[$cookie_name]=urldecode($DUMMY[$cookie_name]);

return($DUMMY);
}

function Encode($pass){
$saltset=array('a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z',
'A','B','D','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z',
'1','2','3','4','5','6','7','8','9','0');
$count=count($saltset)-1;
srand();
$salt=$saltset[rand(0,$count)].$saltset[rand(0,$count)];
$newcode=@crypt($pass,$salt);
if(preg_match("/^\$1\$/",$newcode)){
	$newcode=@crypt($pass,'$1$');
}
return $newcode;
}

function MatchPass($pass,$coded){
$passflag=0;
if(preg_match("/^\$1\$/",$coded)){
	if(crypt($pass,'$1$') == $coded){
		$passflag=1;
	}
}
else{
	$salt=substr($coded,0,2);
	if(crypt($pass,$salt) == $coded){
		$passflag=1;
	}
}
return $passflag;
}


function CheckPass($f){
global $passwd;

if($f['pass'] == ""){
	$m="";
	if($f['cookie']){
		self::DelCookie();
		$m="<br>クッキーを削除しました。";
	}
	self::Error("パスワードを入力してください。".$m);
}

if($passwd == ""){
	self::Error("パスワードが設定されていません。");
}

if($passwd == 'admin'){
	if($f['pass'] != $passwd){
		self::Error("パスワードが違います。");
	}
}
else{
	if(!self::MatchPass($f['pass'],$passwd)){
		self::Error("パスワードが違います。");
	}
}
return;
}


function Ent($fo){
global $cookie_name;
global $ascript;
$DUMMY=self::GetCookie();
$pass=$DUMMY[$cookie_name];

self::Head("");

print <<<EOM
<body>
<div class="midasi w300">管理用</div>
<p class="t_center">パスワードを入力してログインボタンを押してください。</p>
<form action="{$ascript}" method="POST">
<input type="hidden" name="mode" value="atop">
<table class="table_fo box_center">
<tr>
<td>パスワード</td>
<td><input type="password" name="pass" maxlength="8" size="8" value="{$pass}"> <input type="submit" value="ログイン"></td>
</tr>
<tr>
<td></td>
<td><input type="checkbox" name="cookie" value="1">クッキー</td>
</tr>
</table>
</form>
</body>
</html>
EOM;
exit;
}



function Atop($fo){
global $mscript;
global $review;
global $ascript;


if(!$fo['ok'] && $fo['cookie']){
	self::SetCookie($fo['pass']);
}

self::Head("");

print <<<EOM
<body>
<div class="midasi w300">機能の選択</div>
<p class="t_center">機能を選んでボタンを押してください。</p>

<form action="$ascript" method="POST">
<input type="hidden" name="pass" value="{$fo['pass']}">
<input type="hidden" name="mode" value="menu">
<ul class="btn_table box_center">
<li>
<input type="button" name="menu" value="部屋の登録・編集" class="bt" onclick="jump('room_top')">
</li>
<li>
<input type="button" name="menu" value="環境設定" class="bt" onclick="jump('set_top')">
</li>
</ul>
</form>
<form name="fo" action="$ascript" method="POST" style="margin:0px">
<input type="hidden" name="pass" value="{$fo['pass']}">
<input type="hidden" name="mode" value="">
</form>
<script>

function jump(m){
document.fo.mode.value=m;
document.fo.submit();
}

</script>
</body>
</html>
EOM;
exit;

}




function Head($a){
global $ascript;

header("Content-type: text/html");

print <<<EOM
<!DOCTYPE HTML>
<html>
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<meta http-equiv="Pragma" content="no-cache">
<meta http-equiv="expires" content="0">
<meta name="ROBOTS" content="NOINDEX,NOFOLLOW,NOARCHIVE">
<title>管理</title>
<style type="text/css">
<!--

.box_center{
	margin: 0 auto;
}

.set_tbl{
	border:1px solid #D0B195;
	border-collapse:collapse;
}
.set_tbl td{ 
	border:1px solid #D0B195;
	border-collapse:collapse;
}

.btn_table{
	width: 200px;
	list-style: none;
}

.btn_table li{
	margin-bottom: 15px;
}

ul {
	list-style: none;
	margin-left: 0;
	padding-left: 0;
}

.bt{
	width: 200px;
}

.b{
	font-weight: bold;
}

p,
td,
div{
	font-size: 13px;
}

.midasi{
	background-color: #924141;
	color: #ffffff;
	font-weight: bold;
	width: 870px;
	margin: 0 auto;
	text-align: center;
}

.t_center{
	text-align: center;
}

.aste{
	color: #cc0000;
}

.site_tbl{
	border:1px solid #D0B195;
	border-collapse:collapse;
}

.site_tbl tr{
	background-color:#FFF8F4;
}

.site_tbl td{ 
	border:1px dotted #D0B195;
	border-collapse:collapse;
}

.site_tbl thead tr{
	background-color: #F9EFEC;
}

.site_tbl thead td{
	font-weight: bold;
}

.bg{
	background-color:#FFF8F4;
}

.bg2{
	background-color:#FFF8F4;
}

.komoku{
	font-weight: bold;
	background-color:#ECDCD7;
}

.midasi{
	font-weight:bold;
}
.noline{
	border:none;
}
.noline td{
	border:none;
}

a.navi:link{
	text-decoration:none;
	color:#0000ff;
}
a.navi:visited{
	text-decoration:none;
	color:#0000ff;
}
a.navi:active{
	text-decoration:none;
	color:#0000ff;
}
a.navi:hover{
	position:relative;left:1px;top:1px;
	color:#0000ff;
}

.obi{
	background-color:#924141;
}

.cl{
	width: 100%;
}

.cl:after {
	content: ""; 
	display: block; 
 	clear: both;
}

.mb5{
	margin-bottom: 5px;
}

.mt10{
	margin-top: 10px;
}

.mt20{
	margin-top: 20px;
}

.mt4{
	margin-top: 4px;
}

.mb20{
	margin-bottom: 20px;
}

ul.pagelink{
	list-style-type: none;
	margin: 0;
}

ul.pagelink li{
	float: left;
}

ul.pagelink a, ul.pagelink li.current{
	display: block;
	width: 20px;
	line-height: 20px;
	text-align: center;
	text-decoration: none;
	border-style: solid;
	border-color: #bebebe;
	border-width: 1px;
	margin-right: 3px;
	padding:1px;
	font-size: 13px;
}

ul.pagelink li.ten{
	width: 15px;
	text-align: center;
	margin-right: 3px;
	padding:1px;
}

ul.pagelink a:hover{
	background-color: #F0F0F0;
}

ul.pagelink:after{
	display: block;
	clear: both;
	content: '';
}

ul.pagelink li.current{
	font-weight:bold;
}


div.page {
	position: relative;
	overflow: hidden;
	margin-bottom: 10px;
}


div.page ul {
	float:left;
	left:0%;
	position:relative;
	padding:0px;
}

div.page li {
	float:left;
	left:0%;
	position:relative;
}

#loader{
	display: none;
	width: 300px;
	height: 200px;
	margin: 20px auto 0 auto;
	text-align: center;
	border-style: solid;
	border-color: #000000;
	border-width: 1px;
	padding: 10px;
	box-sizing: border-box;
}

#msg{
	margin-top: 15px;
	margin-bottom: 10px;
}

.r{
	color:#cc0000;
}

.btn1{
	width: fit-content;
}

.btn2{
	display: none;
	width: fit-content;
}

#henkou_btn{
	display: none;
	text-align: center;
	margin-bottom: 3px;
}

@media screen and (max-width:600px){
	div,
	p,
	td{
		font-size: 15px;
		line-height:150%;
	}

	body{
		font-size: 15px;
		line-height:150%;
	}
	
	div,p,td,th{
		font-size: 15px;
		line-height:150%;
	}

	input[type=text],input[type=password],textarea{
		border: 1px solid #999999;
		border-radius: 3px;
		margin-bottom: 1px;
	}
	
	select{
		border: 1px solid #999999;
		width: 80px;
	}

	input,select {
	 	height: 34px;
	 	box-sizing: border-box;
	}

	textarea {
		box-sizing: border-box;
		line-height: 1.25;
		padding: 4px;
	}
	
	input[type=checkbox]{
		width: 24px;
		height: 24px;
	}

	.table_fo {
		width: 100%;
	}

	.table_fo tr,
	.table_fo th,
	.table_fo td {
		display: block;
		width: auto;
		padding: 2px;
	}
	
	.table_fo tr{
		margin-bottom: 20px;
	}

	.table_fo th {
		padding-bottom: 0;
	}

	.table_fo input[type='text'],
	.table_fo input[type='password'],
	.table_fo select,
	.table_fo textarea {
		width: 100%;
	}

	.btn_table li{
		margin-bottom: 20px;
	}
	
	.midasi{
		width: 100%;
	}
	
	.set_tbl{ 
		border: 0;
	}
	.set_tbl td{ 
		border: 0;
	}
	
	.room_tbl {
		border: none;
		width: 100%;
	}
	.room_tbl thead {
		display: none;
	}

	.room_tbl tr {
		display: block;
		width: auto;
		border: 1px solid #D0B195;
		border-radius: 5px;
		margin-bottom: 20px;

	}
	.room_tbl td {
		display: block;
		border: none;
		border-bottom: 1px dotted #D0B195;
		text-align: left;
		padding: 3px;

	}
	.room_tbl td:nth-last-child(2) {
		border-bottom: none;
	}
	.room_tbl td:last-child {
		display: none;
	}
	.room_tbl td:nth-of-type(n+1):nth-of-type(-n+5):before {
		content: attr(data-label);
		display: block;
		font-weight: bold;
		float: left;
		padding-right: 5px;
		white-space: nowrap;
		width: 70px;
		border-right-style: dotted;
		border-right-width: 1px;
		border-color: #D0B195;
	}

	.page{
		width: 100%;
	}

	ul.pagelink a, ul.pagelink li.current{
		display: block;
		width: 30px;
		line-height: 30px;
		text-align: center;
		text-decoration: none;
		border-style: solid;
		border-color: #bebebe;
		border-width: 1px;
		margin-right: 5px;
		padding:1px;
		font-size: 13px;
		border-radius: 3px;
	}
	
	ul.pagelink li.ten{
		width: 20px;
		text-align: center;
		margin-right: 5px;
		padding:1px;
	}

	ul.pagelink a:hover{
		background-color: #F0F0F0;
	}
	
	.btn1{
		display: none;
	}

	.btn2{
		display: inline;
	}
	
	#henkou_btn{
		display: block;
	}
	
	.bg2{
		background-color: #ffffff;
	}
}

-->
</style>
<script>
EOM;

if($a){
print <<<EOM
function Alert(){
	alert("{$a}");
}
window.onload=Alert;
EOM;
}

print <<<EOM
</script>
</head>
EOM;

}



function Error($e){
global $pagetitle;

header("Content-type: text/html");

print <<<EOM
<!DOCTYPE HTML>
<html>
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<meta http-equiv="Pragma" content="no-cache">
<meta http-equiv="expires" content="0">
<meta name="ROBOTS" content="NOINDEX,NOFOLLOW,NOARCHIVE">
<title>$pagetitle</title>
<style type="text/css">
<!--

-->
</style>
<body>
ERROR
EOM;

print "$e\n";

print <<<EOM
</body>
</html>
EOM;

exit;

}



function FileType($t,$n){
global $UPOK;
if($t == ""){
	return;
}
list($dum,$t)=explode("/",$t);

$type=array('pjpeg'=>'jpg','jpeg'=>'jpg','gif'=>'gif');

if($t == 'octet-stream' && preg_match("/\.csv$/",$n)){
	$type[$t]='csv';
}

if(!$type[$t]){
	return;
}
$tt=$type[$t];
if(!$UPOK[$tt]){
	return;
}
return $tt;
}


function ImgDel($upfilename,$upfilename_k){

if(count($upfilename)){
	foreach($upfilename as $v){
		if($v){
			if(file_exists("$upimgdir$v")){
				unlink("$upimgdir$v") || exit;
			}
		}
	}
}
if(count($upfilename_k)){
	foreach($upfilename_k as $v){
		if($v){
			if(file_exists("$upimgdir$v")){
				unlink("$upimgdir$v") || exit;
			}
		}
	}
}

}


function ParseInt(){
global $tag;

if($_SERVER['REQUEST_METHOD'] == 'POST'){
	$ary=&$_POST;
}
else{
	$ary=&$_GET;
}

$in=array();
foreach($ary as $name => $value){
	$value=str_replace("&","",$value);
	$value=str_replace(",","&#44;",$value);
	$value=str_replace("<","",$value);
	$value=str_replace(">","",$value);
	$value=str_replace('"',"",$value);
	$value=str_replace("'","",$value);
	if($name == "kinsigo"){
		$value=str_replace("\r\n","\n",$value);
		$value=str_replace("\r","\n",$value);
	}
	else{
		$value=str_replace("\r\n","",$value);
		$value=str_replace("\n","",$value);
		$value=str_replace("\r","",$value);
	}
	$in[$name]=$value;

}


return $in;
}





}//Class end

?>