<?php


Class Chat{

function Room($fo){
global $roomskin;
global $roomlog;
global $roommax;
global $logdir;
global $color_aki;
global $color_mansitu;
global $color_taiki;
global $max_def;
global $chatname;
global $o_main;
global $o_func;


$fp=@fopen($roomskin,'r');
if(!$fp){
	$o_main->Error("skinが開けません。");
}
while($ln=fgets($fp)){
	$skinline.=$ln;
}
fclose($fp);



list($head,$dummy) = explode("<!--row-->",$skinline);

if($dummy == ""){
	$o_main->Error("スキンに&lt;!--row--&gt;が書かれていません。");
}

list($table,$foot) = explode("<!--/row-->",$dummy);
if($foot == ""){
	$o_main->Error("スキンに&lt;!--/row--&gt;が書かれていません。");
}


$head=str_replace("<!--chat-->",$chatname,$head);
$head=str_replace("#chat",$chatname,$head);

header("Content-type: text/html");
print $head;

$fp=@fopen($roomlog,'r');
if(!$fp){
	$o_main->Error("skinが開けません。");
}
$hd=fgets($fp);
$rooms=array();
while($ln=fgets($fp)){
	list($room,$room_name,$max)=explode(",",$ln);
	$rooms[]=array('room'=>$room,'room_name'=>$room_name,'max'=>$max);
}
fclose($fp);

foreach($rooms as $room){
	if($room['max'] == ""){
		$room['max']=$max_def;
	}
	$file=$logdir.$room['room'].'_member.log';

	$num=0;
	$memline="";
	if(!file_exists($file)){
		continue;
	}
	else{
		$members=$o_func->GetMembers($room['room']);
		$mem=$members[0];
		$num=count($members);
		if($num){
			$flag=$o_func->CheckTimeIni($room['room'],$num,$mem['no']);
			if($flag){
				$num=0;
			}
			else{
				foreach($members as $mem){
					$name=$mem['name'];
					$seibetu=$mem['seibetu'];
					$area=$mem['area'];
					$konreki=$mem['konreki'];
					$comment=$mem['comment'];
					$age=$mem['age'];
					$memline.="$name $age $seibetu $area $konreki $comment<br>";
				}
			}
		}
	}
	$table_d=$table;
	$table_d=str_replace("<!--room-->",$room['room_name'],$table_d);
	$table_d=str_replace("<!--members-->",$memline,$table_d);
	$table_d=str_replace("<!--max-->",$room['max'],$table_d);
	$table_d=str_replace("<!--now-->",$num,$table_d);
	$table_d=str_replace("<!--age-->",$age,$table_d);

	$table_d=str_replace("#room",$room['room'],$table_d);

	$r=$o_func->LockCheck($room['room']);
	if($r || ($room['max'] == $num)){
		$table_d=str_replace('id="btn"',"disabled",$table_d);
	}
	if($room['max'] == $num){
		$status="<span style=\"color:{$color_mansitu}\">満室</span>";
		$table_d=str_replace("id=\"btn\"","disabled",$table_d);
	}
	else if($r){
		$status="<span style=\"color:{$color_mansitu}\">会話中</span>";
	}
	else if($num == 0){
		$status="<span style=\"color:{$color_aki}\">空室</span>";
	}
	else{
		$status="<span style=\"color:{$color_taiki}\">待機中</span>";
	}
	$table_d=str_replace("<!--status-->",$status,$table_d);

	print $table_d;

}


print $foot;

exit;
}

function Enter($fo){
global $enterskin;
global $SEIBETU;
global $COLOR;
global $AREA;
global $AGE;
global $KONREKI;
global $color_m;
global $color_w;
global $timer_taiki;
global $timer_fukusu;
global $timer_mugon;
global $skinline;
global $chatname;
global $o_main;
global $o_func;

$fp=@fopen($enterskin,'r');
if(!$fp){
	$o_main->Error("skinが開けません。");
}
while($ln=fgets($fp)){
	$skinline.=$ln;
}
fclose($fp);

$skinline=str_replace("#chat",$chatname,$skinline);
$ROOM=$o_func->GetRoom($fo['room']);

$skinline=str_replace("#room_name",$ROOM['room_name'],$skinline);
$skinline=str_replace("#room",$fo['room'],$skinline);

$skinline=str_replace("<!--chat-->",$chatname,$skinline);
$skinline=str_replace("<!--room_name-->",$ROOM['room_name'],$skinline);

if($_COOKIE['chat']){
	list($name,$seibetu,$color,$area,$age,$konreki)=explode(",",$_COOKIE['chat']);
}

$skinline=str_replace("#name",$name,$skinline);

$seibetuline="";
foreach($SEIBETU as $v){
	if($v == $seibetu){
		$ck=" checked";
	}
	else{
		$ck="";
	}
	if($v == '男'){
		$col=$color_m;
	}
	else if($v == '女'){
		$col=$color_w;
	}
	$seibetuline.="<input type=\"radio\" name=\"seibetu\" value=\"{$v}\"{$ck}><span style=\"color:$col\">{$v}</span>";
}

$skinline=str_replace("<!--seibetu-->",$seibetuline,$skinline);

$colorline="";
foreach($COLOR as $v){
	if($v == $color){
		$ck=" checked";
	}
	else{
		$ck="";
	}
	$colorline.="<input type=\"radio\" name=\"color\" value=\"{$v}\"{$ck}><span style=\"color:$v\">■</span>\n";
}

$skinline=str_replace("<!--color-->",$colorline,$skinline);


$arealine="";
foreach($AREA as $v){
	if($v == $area){
		$ck=" selected";
	}
	else{
		$ck="";
	}
	$arealine.="<option value=\"{$v}\"{$ck}>{$v}</option>\n";
}

$skinline=str_replace("<!--area-->",$arealine,$skinline);


$ageline="";
foreach($AGE as $v){
	if($v == $age){
		$ck=" selected";
	}
	else{
		$ck="";
	}
	$ageline.="<option value=\"{$v}\"{$ck}>{$v}</option>\n";
}

$skinline=str_replace("<!--age-->",$ageline,$skinline);

$konrekiline="";
foreach($KONREKI as $v){
	if($v == $konreki){
		$ck=" selected";
	}
	else{
		$ck="";
	}
	$konrekiline.="<option value=\"{$v}\"{$ck}>{$v}</option>\n";
}

$skinline=str_replace("<!--konreki-->",$konrekiline,$skinline);

$members=$o_func->GetMembers($fo['room']);
$num=count($members);

if($num !== 0){
	$skinline=preg_replace("/<!--taiki-->.*?<!--\/taiki-->/s","",$skinline);
}

$code=$o_func->MakePass();

$skinline=str_replace("#code",$code,$skinline);

header("Content-type: text/html");
print $skinline;

exit;
}

function DoEnter($fo){
global $o_main;
global $o_func;
global $max_def;

if($fo['name'] == ""){
     $o_main->Error("名前を入力してください。");
}

$ROOM=$o_func->GetRoom($fo['room']);

$members=$o_func->GetMembers($fo['room']);
$num=count($members);

$max=$ROOM['max'];

if($max == ""){
	$max=$max_def;
}

if($num >= $max){
     $o_main->Error("すでに満室です。");
}

if($fo['cookie']){
	$cook="{$fo['name']},{$fo['seibetu']},{$fo['color']},{$fo['area']},{$fo['age']},{$fo['konreki']}";
	setcookie('chat',$cook,time()+3600*24*30);
}


list($no,$mem)=$o_func->MemberCodeCheck($fo['room'],$fo['code']);
if(!$no){
	$no=self::RegistMember($fo);

	if($no == 1){
		self::DelRoomImgs($fo['room']);
	}

	$mem=$o_func->GetMember($fo['room'],$no,"");

	$date=$o_func->GetDate();

	if($no == 1){
		$msg='管理者として';
	}

	$line="{$no},{$fo['name']},{$date},{$mem['name']}さんが{$msg}入室しました。,{$mem['host']},\n";

	self::RegistLine($fo,$line);

}
$fo['no']=$no;

self::Main($fo,$ROOM,$mem);
}

function Main($fo,$ROOM=null,$mem=null){
global $mainskin;
global $mainskin2;
global $logdir;
global $color_m;
global $color_w;
global $hostview;
global $color_jibun;
global $color_aite;
global $COLOR;
global $SIZE_N;
global $SIZE;
global $reload_time;
global $chatname;
global $o_main;
global $o_func;

$fp=@fopen($mainskin,'r');
if(!$fp){
	$o_main->Error("mainskinが開けません。");
}
while($ln=fgets($fp)){
	$skinline.=$ln;
}
fclose($fp);

if(!isset($ROOM)){
	$ROOM=$o_func->GetRoom($fo['room']);
}

$skinline=str_replace("#chat",$chatname,$skinline);
$skinline=str_replace("#room_name",$ROOM['room_name'],$skinline);
$fo['color']=str_replace("#","",$fo['color']);

$colorline="";
$color='#'.$fo['color'];
foreach($COLOR as $v){
	if($v == $color){
		$ck=" checked";
	}
	else{
		$ck="";
	}
	$colorline.="<input type=\"radio\" name=\"color\" value=\"{$v}\"{$ck}><span style=\"color:{$v}\">■</span>\n";
}

$skinline=str_replace("<!--color-->",$colorline,$skinline);

$i=0;
$sizeline="";
foreach($SIZE as $v){
	$sizeline.="<option value=\"{$v}\">{$SIZE_N[$i]}</option>\n";
	$i++;
}

$skinline=str_replace("<!--size-->",$sizeline,$skinline);

$reload_line="";
foreach($reload_time as $v){
	$reload_line.="<option value=\"{$v}\">{$v}</option>\n";
}
$skinline=str_replace("<!--reload-->",$reload_line,$skinline);

if(!isset($mem)){
	$mem=$o_func->GetMember($fo['room'],$fo['no'],"");
}

$skinline=str_replace("<!--name-->",$mem['name'],$skinline);

if(count($reload_time) > 1){
	$reload=$reload_time[1];
}
else{
	$reload=$reload_time[0];
}

$jsline="let reload={$reload};\n";
$jsline.="let num=null;\n";
$jsline.="let ato=null;\n";
$jsline.="let limit=null;\n";
$jsline.="let members=null;\n";
$jsline.="const room='{$fo['room']}';\n";
$jsline.="const no='{$fo['no']}';\n";
$jsline.="const code='{$fo['code']}';\n";
$jsline.="const color_jibun='{$color_jibun}';\n";
$jsline.="const color_aite='{$color_aite}';\n";
$jsline.="const hostview='{$hostview}';\n";

$skinline=str_replace("<!--vars-->",$jsline,$skinline);

header("Content-type: text/html");
print $skinline;

exit;

}


function Reload($fo){
self::Msgs($fo);

}

function Msgs($fo){
global $logdir;
global $o_func;
global $o_main;


$file=$logdir.$fo['room'].'_comment'.'.log';
$fp=@fopen($file,'r');
if(!$fp){
	$o_main->Error("fileが開けません。ファイルを確認してください。");
}
$js="";
while($ln=fgets($fp)){
	list($no,$name,$date,$msg,$host)=explode(",",$ln);
	$js.='{"name":"'.$name.'",';
	$js.='"no":"'.$no.'",';
	$js.='"date":"'.$date.'",';
	$js.='"msg":"'.$msg.'",';
	$js.='"host":"'.$host.'"},';
}
fclose($fp);



list($num,$ato,$limit,$members)=$o_func->GetStatus($fo);

$mline="";
foreach($members as $mem){
	$mline.='{"no":"'.$mem['no'].'","name":"'.$mem['name'].'"},';
}

$js=rtrim($js,",");
$mline=rtrim($mline,",");


$jsline='{"result":"msgs",';
$jsline.='"msgs":['.$js.'],';
$jsline.='"ato":"'.$ato.'",';
$jsline.='"limit":"'.$limit.'",';
$jsline.='"act":"'.$fo['mode'].'",';
$jsline.='"members":['.$mline.']';
$jsline.='}';


header("Content-type: text/json");
print $jsline;
exit;
}


function RegistMember($fo){
global $logdir;
global $o_main;
global $o_func;

$room=$fo['room'];

$file=$logdir.$room.'_member.log';

$fp=@fopen($file,"r+");
if(!$fp){
	$o_main->Error("{$file}が開けません。ファイルを確認してください。");
}
flock($fp,LOCK_EX);
$hd=fgets($fp);
$all=array();
while($ln=fgets($fp)){
	$all[]=$ln;
}

list($no)=explode(",",$hd);
if($no == ""){
	$no=0;
}
$no++;
$hd="$no,\n";

$host=$o_func->GetHost();

$line="{$no},{$fo['name']},{$fo['seibetu']},{$fo['area']},{$fo['age']},{$fo['konreki']},{$fo['comment']},{$fo['code']},{$host},\n";

array_push($all,$line);

fseek($fp,0);
fputs($fp,$hd);
foreach($all as $v){
	fputs($fp,$v);
}
ftruncate($fp,ftell($fp));
fclose($fp);

$timer=time();

$line="$no,$timer,$timer,\n";
$file=$logdir.$room.'_timer.log';

$fp=@fopen($file,"a");
if(!$fp){
	$o_main->Error("logに書き込みできません。パーミッション等を確認してください");
}
flock($fp,LOCK_EX);
fputs($fp,$line);
fclose($fp);

return $no;


}

function DelMember($room,$no){
global $logdir;
global $o_main;

$file=$logdir.$room.'_member.log';
$fp=@fopen($file,"r+");
if(!$fp){
	$o_main->Error("{$file}が開けません。ファイルを確認してください。");
}
flock($fp,LOCK_EX);

$hd=fgets($fp);
$all=array();
while($ln=fgets($fp)){
	list($no_d)=explode(",",$ln);
	$flag=false;
	if($no_d == $no){
		$flag=true;
	}
	if(!$flag){
		$all[]=$ln;
	}
}


fseek($fp,0);
fputs($fp,$hd);
foreach($all as $v){
	fputs($fp,$v);
}
ftruncate($fp,ftell($fp));
fclose($fp);

$file=$logdir.$room.'_timer.log';

$fp=@fopen($file,'r+');
if(!$fp){
	$o_main->Error("fileが開けません。");
}
flock($fp,LOCK_EX);
$all=array();
while($ln=fgets($fp)){
	list($no_d)=explode(",",$ln);
	$flag=false;
	if($no_d == $no){
		$flag=true;
	}
	if(!$flag){
		$all[]=$ln;
	}
}

fseek($fp,0);
foreach($all as $v){
	fputs($fp,$v);
}
ftruncate($fp,ftell($fp));
fclose($fp);

}


function Syuryo($room,$no,$code,$act){
global $thanksskin;
global $logdir;
global $chatname;
global $o_main;
global $o_func;

if($act == "limit" || $act == "notime"){
	$o_func->MemberCheck($room,$no,$code);
	if($no == 1){
		$o_func->FileClear($room);
		self::ImgClean();
		self::DelRoomImgs($room);
	}
	else{
		self::DelMember($room,$no);
	}
}

if($act == "limit"){
	$msg="時間切れです。";
}
else if($act == "notime"){
	$msg="無発言時間が制限を超えました。";
}
else if($act == "taisitu"){
	$msg="退室しました。";
}
else{
	$msg="このチャットは閉鎖されました。";
}


$jsline='{"result":"end",';
$jsline.='"act":"'.$act.'",';
$jsline.='"msg":"'.$msg.'"';
$jsline.='}';


header("Content-type: text/json");
print $jsline;

exit;

}


function Clear($fo){
global $logdir;
global $pagemax;
global $o_main;
global $o_func;

$o_func->MemberCheck($fo['room'],$fo['no'],$fo['code']);


$file=$logdir.$fo['room'].'_comment'.'.log';

$fp=@fopen($file,"w");
if(!$fp){
	$o_main->Error("{$file}に書き込みできません。パーミッション等を確認してください");
}
flock($fp,LOCK_EX);
ftruncate($fp,0);
fclose($fp);


self::Msgs($fo);
}


function Regist($fo){
global $logdir;
global $pagemax;
global $worddeny;
global $o_func;


$o_func->MemberCheck($fo['room'],$fo['no'],$fo['code']);


if($worddeny){
	$o_func->CheckTag($fo['comment']);
}

$mem=$o_func->GetMember($fo['room'],$fo['no'],"main");

$span_s="";
$span_e="";

if($fo['size'] || $fo['color'] || $fo['bld'] || $fo['shadow']){
	$span_s="<span style=\\\"";
	if($fo['size']){
		$span_s.="font-size:{$fo['size']};";
	}
	if($fo['color']){
		$span_s.="color:{$fo['color']};";
	}
	if($fo['bld']){
		$span_s.="font-weight:bold;";
	}
	if($fo['shadow']){
		$span_s.="text-shadow:2px 2px 3px #808080;";
	}
	$span_s.="\\\">";
	$span_e="</span>";
}

$date=$o_func->GetDate();

$line="{$mem['no']},{$mem['name']},{$date},{$span_s}{$fo['comment']}{$span_e},{$mem['host']},\n";

self::RegistLine($fo,$line);

$o_func->RenewTime($fo['room'],$fo['no']);


self::Msgs($fo);
}



function RegistLine($fo,$line){
global $logdir;
global $pagemax;
global $o_main;

$file=$logdir.$fo['room'].'_comment'.'.log';

$fp=@fopen($file,"r+");
if(!$fp){
	$o_main->Error("{$file}が開けません。ファイルを確認してください。");
}
flock($fp,LOCK_EX);
$all=array();
while($ln=fgets($fp)){
	$all[]=$ln;
}
array_unshift($all,$line);

if(count($all) > $pagemax){
	array_pop($all);
}

fseek($fp,0);
foreach($all as $v){
	fputs($fp,$v);
}
ftruncate($fp,ftell($fp));
fclose($fp);

}




function DoTaisituAite($fo){
global $logdir;
global $o_func;


$o_func->MemberCheck($fo['room'],$fo['no'],$fo['code']);

$mem=$o_func->GetMember($fo['room'],$fo['bango'],"main");

$date=$o_func->GetDate();


$line=",,{$date},{$mem['name']}さんが退室させられました。,{$mem['host']},\n";

self::DelMember($fo['room'],$fo['bango']);
self::RegistLine($fo,$line);
self::DelMemImgs($fo['room'],$fo['bango']);

self::Msgs($fo);

}

function Taisitu($fo){
global $logdir;
global $o_func;


$o_func->MemberCheck($fo['room'],$fo['no'],$fo['code']);

$mem=$o_func->GetMember($fo['room'],$fo['no'],"main");

$date=$o_func->GetDate();

$line=",,{$date},{$mem['name']}さんが退室しました。,{$mem['host']},\n";

self::DelMember($fo['room'],$fo['no']);
self::RegistLine($fo,$line);
self::DelMemImgs($fo['room'],$fo['no']);


self::Syuryo($fo['room'],"","","taisitu");
}


function Lock($fo){
global $logdir;
global $o_main;
global $o_func;

$o_func->MemberCheck($fo['room'],$fo['no'],$fo['code']);

$file=$logdir.$fo['room'].'_rlock';

$fp=@fopen($file,"w");
if(!$fp){
	$o_main->Error("{$file}に書き込みできません。パーミッション等を確認してください。");
}
flock($fp,LOCK_EX);
fseek($fp,0);
fputs($fp,"1");
ftruncate($fp,ftell($fp));
fclose($fp);

self::Msgs($fo);
}


function UnLock($fo){
global $logdir;
global $o_main;
global $o_func;

$o_func->MemberCheck($fo['room'],$fo['no'],$fo['code']);

$file=$logdir.$fo['room'].'_rlock';

$fp=@fopen($file,"w");
if(!$fp){
	$o_main->Error("{$file}に書き込みできません。パーミッション等を確認してください。");
}
flock($fp,LOCK_EX);
ftruncate($fp,0);
fclose($fp);

self::Msgs($fo);
}


function Close($fo){
global $o_func;

$o_func->MemberCheck($fo['room'],$fo['no'],$fo['code']);
$o_func->FileClear($fo['room']);
self::ImgClean();
self::DelRoomImgs($fo['room']);
self::Syuryo($fo['room'],"","","thanks");
}


function ImgShow($fo){
global $upimgdir;

$gfile=$upimgdir.$fo['g'];
$gsize=@getimagesize($gfile);
$gw=$gsize[0];
$gh=$gsize[1];

header("Content-type: text/html");

print <<<EOM
<!DOCTYPE HTML>
<html>
<head>
<meta charset="utf-8">
<title></title>
<style type="text/css">
body{
	margin: 0px;
}
</style>
</head>
<body>
<img src="{$gfile}" width="{$gw}" height="{$gh}" border="0">
</body>
</html>
EOM;
exit;


}



function ImgDel($fo){
global $upimgdir;
global $logdir;
global $o_main;
global $o_func;

$o_func->MemberCheck($fo['room'],$fo['no'],$fo['code']);

$imgtmp=explode(":",$_COOKIE['img']);
$eflag=false;
$imgtmp_d=array();
foreach($imgtmp as $v){
	$flag=false;
	if($v == $fo['img']){
		$eflag=true;
		$flag=true;
	}
	if(!$flag){
		$imgtmp_d[]=$v;
	}
}
if(!$eflag){
	$o_main->Error("削除できません。");
}
$imgline=join(":",$imgtmp_d);
setcookie('img',$imgline,time()+3600*24*30);


$file=$upimgdir.$fo['img'];
$tmp=explode('.',$fo['img']);
$ext=array_pop($tmp);
$file_thm=$upimgdir.join(".",$tmp).'_thm.'.$ext;

if(!unlink($file)){
	$o_main->Error("削除できません。");
}
if(!unlink($file_thm)){
	$o_main->Error("削除できません。");
}

$file=$logdir.$fo['room'].'_comment'.'.log';

$fp=@fopen($file,"r+");
if(!$fp){
	$o_main->Error("{$file}が開けません。ファイルを確認してください。");
}
flock($fp,LOCK_EX);
$tmp=array();
while($ln=fgets($fp)){
	$flag=false;
	$pos=strpos($ln,$fo['img']);
	if($pos !== false){
		$flag=true;
	}
	if(!$flag){
		$tmp[]=$ln;
	}
}

fseek($fp,0);
foreach($tmp as $v){
	fputs($fp,$v);
}

ftruncate($fp,ftell($fp));

fclose($fp);


self::Msgs($fo);
}


function ImgClear($fo){
global $logdir;
global $upimgdir;
global $o_main;
global $o_func;

$o_func->MemberCheck($fo['room'],$fo['no'],$fo['code']);

$file=$logdir.$fo['room'].'_comment'.'.log';
$fp=@fopen($file,"r+");
if(!$fp){
	$o_main->Error("{$file}が開けません。ファイルを確認してください。");
}
flock($fp,LOCK_EX);

$pattern="/img src=\\\\\".*?({$fo['room']}_{$fo['no']}_.*?)\\\\\"/";

$tmp=array();
$delimgs=array();
while($ln=fgets($fp)){
	$flag=false;
	if(preg_match_all($pattern,$ln,$ma)){
		foreach($ma[1] as $v){
			$delimgs[]=$v;
		}
		$flag=true;
	}
	if(!$flag){
		$tmp[]=$ln;
	}
}

fseek($fp,0);
foreach($tmp as $v){
	fputs($fp,$v);
}

ftruncate($fp,ftell($fp));

fclose($fp);



foreach($delimgs as $f_thm){
	$f=str_replace("_thm","",$f_thm);
	$file=$upimgdir.$f;
	$file_thm=$upimgdir.$f_thm;
	if(!unlink($file)){
		$o_main->Error("画像が削除できません。");
	}
	if(!unlink($file_thm)){
		$o_main->Error("画像が削除できません。");
	}
}

self::Msgs($fo);
}


function DelMemImgs($room,$no){
global $upimgdir;
global $o_main;

$r=$room.'_'.$no.'_';


$files=array();
if($dir=opendir($upimgdir)){
	while($f=readdir($dir)){
		if($f != "." && $f != ".."){
			array_push($files,$f);
		}
	}
	closedir($dir);
	foreach($files as $v){
		if(strpos($v,$r) === 0){
			$file=$upimgdir.$v;
			if(!unlink($file)){
				$o_main->Error("{$file}が削除できません。");
			}
		}
	}
}

}

function DelRoomImgs($room){
global $upimgdir;
global $o_main;

$r=$room.'_';

$files=array();
if($dir=opendir($upimgdir)){
	while($f=readdir($dir)){
		if($f != "." && $f != ".."){
			array_push($files,$f);
		}
	}
	closedir($dir);
	foreach($files as $v){
		if(strpos($v,$r) === 0){
			$file=$upimgdir.$v;
			if(!unlink($file)){
				$o_main->Error("{$file}が削除できません。");
			}
		}
	}
}

}

function ImgClean(){
global $upimgdir;
global $o_main;

$now=time();
$files=array();
if($dir=opendir($upimgdir)){
	while($f=readdir($dir)){
		if($f != "." && $f != ".."){
			array_push($files,$f);
		}
	}
	closedir($dir);
	foreach($files as $v){
		$file=$upimgdir.$v;
		$stat=stat($file);
		$time=$stat['mtime'];
		if(($now-$time) > 24*60*60){
			if(file_exists($file)){
				if(!unlink($file)){
					$o_main->Error("ファイルが削除できません。");
				}
			}
		}
	}
}


}


function Upload($fo){
global $script;
global $upimgdir;
global $logdir;
global $o_func;
global $pagemax;


$o_func->MemberCheck($fo['room'],$fo['no'],$fo['code']);

list($fname,$w,$h,$fname_thm,$w_thm,$h_thm)=self::DoUpload($fo);

$imgtmp=explode(":",$_COOKIE['img']);

array_push($imgtmp,$fname);
if(count($imgtmp) > $pagemax){
	array_shift($imgtmp);
}
$imgline=join(":",$imgtmp);
setcookie('img',$imgline,time()+3600*24*30);


if($fo['kakudai']){
	$real_w=$w+20;
	$real_h=$h+10;
	$href1="<a href=\\\"javascript:void(0);\\\" onclick=\\\"imgopenwin('{$script}?mode=imgshow&g={$fname}:{$real_w}:{$real_h}');\\\">";
	$href2="</a>";
}
else{
	$href1="";
	$href2="";
}

$mem=$o_func->GetMember($fo['room'],$fo['no'],"main");

$date=$o_func->GetDate();

$line="{$mem['no']},{$mem['name']},{$date},{$href1}<img src=\\\"{$upimgdir}{$fname_thm}\\\" width=\\\"{$w_thm}\\\" height=\\\"{$h_thm}\\\" border=\\\"0\\\" class=\\\"protect\\\">{$href2} <a href=\\\"javascript:void(0);\\\" onclick=\\\"ImgDel('{$fname}');\\\">削除</a>,{$mem['host']},\n";


self::RegistLine($fo,$line);

$o_func->RenewTime($fo['room'],$fo['no']);

self::Msgs($fo);
}


function DoUpload($fo){
global $max_filesize;
global $upimgdir;
global $kinsi;
global $o_main;
global $o_func;

$key='upfile';

$s=$_FILES[$key]['size'];
$n=$_FILES[$key]['name'];
$t=$_FILES[$key]['type'];
$tm=$_FILES[$key]['tmp_name'];


$ext=self::fType($t);

if(!$ext){
	$o_main->Error("アップロードできないファイル形式です。");
}
if($s > $max_filesize){
	$o_main->Error("投稿のサイズが大きすぎます。。");
}
if($_FILES[$key]['error']){
	$o_main->Error("{$key}のアップロードに失敗しました。");
}

$ROOM=$o_func->GetRoom($fo['room']);
$mem=$o_func->GetMember($fo['room'],$fo['no'],"main");

$na=$ROOM['no'].'_'.$mem['no'].'_'.$o_func->MakeImgId().'.'.$ext;
$imgfile=$upimgdir.$na;

$upfile=$tm;

if(!move_uploaded_file($upfile,$imgfile)){
	$o_main->Error("アップロードに失敗しました。");
}
$size=@getimagesize($imgfile);
$w=$size[0];
$h=$size[1];

if(!$w || !$h){
	$o_main->Error("画像サイズが取得できませんでした。");
}

$w_t=$fo['tsize'];

if($h > $w){
	$h_t=$w_t;
	$w_t=floor($w*$h_t/$h);
}
else{
	$h_t=floor($h*$w_t/$w);
}

list($fname_thm,$w_thm,$h_thm)=self::Thumbnail($imgfile,$na,$w_t,$h_t,$w,$h);

return array($na,$w,$h,$fname_thm,$w_thm,$h_thm);
}


function fType($t){
global $UPOK;

if($t == ""){
	return;
}
list($dum,$t)=explode("/",$t);

$type=array('pjpeg'=>'jpg','jpeg'=>'jpg','gif'=>'gif','png'=>'png','x-png'=>'png');

if(!$type[$t]){
	return;
}
$tt=$type[$t];

if(!$UPOK[$tt]){
	return;
}
return $tt;
}



function Thumbnail($imgfilename,$fname,$w_t,$h_t,$w,$h){
global $upimgdir;


$tmp=explode('.',$fname);
$ext=array_pop($tmp);
$imgfile=join(".",$tmp).'_thm.'.$ext;

if($ext == 'jpg'){
	$image=imagecreatefromjpeg($imgfilename);;
	$new_image=imagecreatetruecolor($w_t,$h_t);
	imagecopyresampled($new_image,$image,0,0,0,0,$w_t,$h_t,$w,$h);
	$imgfilename = $upimgdir.$imgfile;
	imagejpeg($image,$imgfilename);
	imagedestroy($image);
}
else if($ext == 'gif'){
	$image=imagecreatefromgif($imgfilename);
	$new_image=imagecreatetruecolor($w_t,$h_t);
	imagecopyresampled($new_image,$image,0,0,0,0,$w_t,$h_t,$w,$h);
	$imgfilename = $upimgdir.$imgfile;
	imagegif($image,$imgfilename);
	imagedestroy($image);
}
else if($ext == 'png'){
	$image=imagecreatefrompng($imgfilename);
	$new_image=imagecreatetruecolor($w_t,$h_t);
	imagecopyresampled($new_image,$image,0,0,0,0,$w_t,$h_t,$w,$h);
	$imgfilename = $upimgdir.$imgfile;
	imagepng($image,$imgfilename);
	imagedestroy($image);

}


return array($imgfile,$w_t,$h_t);

}


}//Class End

?>
