<?php

error_reporting(E_ALL & ~E_NOTICE & ~E_WARNING & ~E_DEPRECATED);

//----ライブラリ読込み---------------

require_once('./lib/conf.php');
require_once('./lib/func.php');
require_once('./lib/db_sqlite.php');
require_once('./lib/db_fields.php');

//------------------------------------------------

$o_main=new Main;
$o_func=new Func;
$o_db=new DB;
$fo=$o_main->ParseInt();

switch($fo['mode']){
	case "form":
		$o_main->Form($fo);
		break;
	case "regist":
		$o_main->Regist($fo);
		break;
	case "editregist":
		$o_main->EditRegist($fo);
		break;
	default:
		$o_main->Memo($fo);
		break;
}


Class Main{

function Memo($fo){
global $memoskin;
global $o_db;
global $memodb;
global $o_func;

$date=localtime();
$mon=$date[4];
$mon++;
$year=$date[5];
$year=$year+1900;

$mon_now=$mon;
$year_now=$year;

if($fo['year']){
	$year=$fo['year'];
}
if($fo['month']){
	$mon=$fo['month'];
}

$days = array(31,28,31,30,31,30,31,31,30,31,30,31);

if( (($year%4 ==0)&&($year%100 != 0))||($year%400 == 0) ){
	$days[1]=29;
}

$last=$days[$mon-1];

$first=self::wday($year,$mon,1);

$ho=self::holiday($year,$mon,$first,$last);

if($mon==12){
	$nextyear=$year+1;
	$nextmonth=1;
}
else{
	$nextmonth=$mon+1;
	$nextyear=$year;
}

if($mon==1){
	$beforeyear=$year-1;
	$beforemonth=12;
}
else{
	$beforemonth=$mon-1;
	$beforeyear=$year;
}


$prev="<a href=\"javascript:void(0);\" onclick=\"Link('{$beforeyear}','{$beforemonth}');\">前←</a>";
$next="<a href=\"javascript:void(0);\" onclick=\"Link('{$nextyear}','{$nextmonth}');\">→次</a>";


$now="$year/$mon";

if($mon == $mon_now && $year == $year_now){
	$prev="";
}


$fp=@fopen($memoskin,'r');
if(!$fp){
	self::Error("memoskinが開けません。");
}
while($ln=fgets($fp)){
	$skinline.=$ln;
}
fclose($fp);

list($head,$dummy)=explode('<!--start-->',$skinline);
if($dummy == ""){
	self::Error("スキンに&lt;!--start--&gt;が書かれていません。");
}
list($tr,$footer)=explode('<!--end-->',$dummy);
if($footer == ""){
	self::Error("スキンに&lt;!--end--&gt;が書かれていません。");
}

$head=str_replace("<!--now-->",$now,$head);
$head=str_replace("<!--prev-->",$prev,$head);
$head=str_replace("<!--next-->",$next,$head);

$m_f=sprintf("%02d",$mon);
$m=$year.$m_f;


$pdo=$o_db->DBOpen($memodb);
$stmt=$o_db->SetPH("SELECT * FROM memo WHERE m=?",$pdo);
$o_db->DoExc($stmt,[$m]);
$memo=$o_func->GetAllData($stmt);

header("Content-type: text/html");
print $head;

if($first != 0){
	for($i=0;$i<$first;$i++){ 
		$col++;
	}
}



for($i=1;$i<=$last;$i++){
	$tr_d=$tr;
	$anum=0;
	$bnum=0;
	$d_f=sprintf("%02d",$i);
	$key=$year.$m_f.$d_f;
	
	$comment=$memo[$key]['comment'];

	$hflag=0;
	foreach($ho as $v){
		if($v == $i){
			$hflag=1;
			break;
		}
	}

	if($hflag || $col == 0){
		$tr_d=str_replace('"d"','"h"',$tr_d);
	}
	else if($col == 6){
		$tr_d=str_replace('"d"','"s"',$tr_d);
	}
	$eflag="";
	if(isset($memo[$key])){
		$eflag="1";
	}

	$d="<a href=\"javascript:void(0);\" onclick=\"Form('{$year}','{$m_f}','{$d_f}','{$eflag}')\">{$i}</a>";

	$tr_d=str_replace("<!--d-->",$d,$tr_d);
	if($comment){
		$tr_d=str_replace("<!--c-->",$comment,$tr_d);
	}
	print $tr_d;
	$col++;
	if($col>=7){ 
		if($i<$last){
			$col=0;
		}
	}
}



$table.="</table>";

print $table;


print $footer;

exit;

}


function Form($fo){
global $formskin;
global $o_func;
global $o_db;
global $memodb;

$date=$fo['year'].$fo['month'].$fo['day'];

$pdo=$o_db->DBOpen($memodb);
$stmt=$o_db->SetPH("SELECT * FROM memo WHERE date=?",$pdo);
$o_db->DoExc($stmt,[$date]);
$memo=$o_db->GetData($stmt);


$fp=@fopen($formskin,'r');
if(!$fp){
	self::Error("formskinが開けません。");
}
while($ln=fgets($fp,$lbuf)){
	$skinline.=$ln;
}
fclose($fp);

if($fo['e']){
	$mode="editregist";
}
else{
	$mode="regist";
}


$memo['comment']=$o_func->HtmlUnEsc($memo['comment']);

$skinline=str_replace("#year",$fo['year'],$skinline);
$skinline=str_replace("#month",$fo['month'],$skinline);
$skinline=str_replace("#day",$fo['day'],$skinline);
$skinline=str_replace("#mode",$mode,$skinline);
$skinline=str_replace("#date",$fo['year'].$fo['month'].$fo['day'],$skinline);
$skinline=str_replace("#comment",$memo['comment'],$skinline);
$skinline=str_replace("#m",$fo['year'].$fo['month'],$skinline);

$skinline=str_replace("<!--year-->",$fo['year'],$skinline);
$skinline=str_replace("<!--month-->",$fo['month'],$skinline);
$skinline=str_replace("<!--day-->",$fo['day'],$skinline);

header("Content-type: text/html");
print $skinline;
exit;

}


function Regist($fo){
global $memodb;
global $o_db;
global $FIELDS;

$pdo=$o_db->DBOpen($memodb);
list($nline,$qline)=$o_db->MakeNQLine($FIELDS['memo']);
$vary=$o_db->MakeVAry($FIELDS['memo'],$fo);
$stmt=$o_db->SetPH("INSERT INTO memo ($nline) VALUES ($qline)",$pdo);
$o_db->DoExc($stmt,$vary);

self::Memo($fo);
}

function EditRegist($fo){
global $memodb;
global $o_db;
global $FIELDS;

$pdo=$o_db->DBOpen($memodb);
if($fo['comment']){
	$ln=$o_db->MakeQLine($FIELDS['memo']);
	$vary=$o_db->MakeVAry($FIELDS['memo'],$fo);
	$stmt=$o_db->SetPH("UPDATE memo SET $ln WHERE date=?",$pdo);
	$vary[]=$fo['date'];
	$o_db->DoExc($stmt,$vary);
}
else{
	$stmt=$o_db->SetPH("DELETE FROM memo WHERE date=?",$pdo);
	$o_db->DoExc($stmt,[$fo['date']]);
}


self::Memo($fo);
}

function wday($year,$month,$day){

if($month<3){
	$month+=12;
	$year--;
}
return ($year+floor($year/4)-floor($year/100)+floor($year/400)+floor((13*$month+8)/5)+$day)% 7;
}

function holiday($year,$mon,$start,$lastday){
global $holiday_kotei;
global $holiday_daini;
global $holiday_daisan;

$kotei=array();
$ho=array();
$daisan_mon=array();
$daini_mon=array();;

$fp=@fopen($holiday_kotei,'r');
if(!$fp){
	self::Error("holiday_koteiが開けません。");
}
while($ln=fgets($fp)){
	$ln=rtrim($ln,"\n");
	list($m,$d)=explode("/",$ln);
	if($m == $mon){
		array_push($kotei,$d);
	}
}
fclose($fp);


$fp=@fopen($holiday_daini,'r');
if(!$fp){
	self::Error("holiday_dainiが開けません。");
}
while($ln=fgets($fp)){
	$ln=rtrim($ln,"\n");
	if($mon == $ln){
		array_push($daini_mon,$ln);
	}
}
fclose($fp);

$fp=@fopen($holiday_daisan,'r');
if(!$fp){
	self::Error("holiday_daisanが開けません。");
}
while($ln=fgets($fp,$lbuf)){
	$ln=rtrim($ln,"\n");
	if($mon == $ln){
		array_push($daisan_mon,$ln);
	}
}
fclose($fp);


if($mon == 3){
	$d = floor(20.8431+0.242194*($year-1980)-floor(($year-1980)/4));
	array_push($kotei,$d);
}
else if($mon == 9){
	$d = floor(23.2488+0.242194*($year-1980)-floor(($year-1980)/4));
	array_push($kotei,$d);
}

if(!count($kotei) && !count($daini_mon) && !count($daisan_mon)){
	return($ho);
}



$col=0;
if($start!=0){
	for($i=0;$i<$start;$i++){
		$col++;
	}
}
$mcount=0;
$kokuflag=0;
$kokucount=0;
$flag=0;
for($i=1;$i<=$lastday;$i++){
	$hflag=0;
	if($col == 1){
		$mcount++;
		if($mcount == 2){
			if(count($daini_mon)){
				array_push($ho,$i);
				$hflag=1;
			}

		}
		else if($mcount == 3){
			if(count($daisan_mon)){
				array_push($ho,$i);
				$hflag=1;
			}
		}
	}

	foreach($kotei as $v){
		if($i == $v){
			if($col == 0){
				$flag=1;
			}
			else{
				array_push($ho,$i);
				$hflag=1;
			}
		}
	}

	if($col != 0){
		if($flag && !$hflag){
			array_push($ho,$i);
			$flag=0;
		}
	}

	if($kokuflag){
		if(!$hflag){
			$kokucount++;
		}
		else{
			if($kokucount == 2){
				array_push($ho,$i-1);
				$kokuflag=0;
				$kokucount=0;
			}
			else if($kokucount > 2){
				$kokuflag=0;
				$kokucount=0;
			}
		}
	}
	if($hflag && !$kokuflag){
		$kokuflag=1;
		$kokucount++;
	}

	$col++;
	if($col>=7){ 
		if($i<$lastday){
			$col=0;
		}
	}

}


return $ho;
}



function Head(){

print <<<EOM
<!DOCTYPE HTML>
<html>
<head>
<meta charset="utf-8">
<title>エラー</title>
</head>
<body>
EOM;
}


function Error($e){

self::Head();

print <<<EOM
<h3>ERROR</h3>
<p>
EOM;

print $e;

print <<<EOM
</p>
</body>
</html>
EOM;
exit;
}


function ParseInt(){
global $o_func;

if($_SERVER['REQUEST_METHOD'] == 'POST'){
	$ary=&$_POST;
}
else{
	$ary=&$_GET;
}

$in=array();
foreach($ary as $name => $value){
	$name=$o_func->HtmlEsc($name);
	$value=$o_func->HtmlEsc($value);
	$name=SQLite3::escapeString($name);
	$value=SQLite3::escapeString($value);
	$in[$name]=$value;
}

return $in;
}



}
?>

