#!/usr/bin/perl

#↑Perlのパス サーバーのマニュアルをみて確認する

#-------------- 基本設定------------

$pd='admin';		#管理パス


$pagetitle="管理用";
$script="admin.cgi";

#---------------------------------------------
$maxsize=10000;		#投稿量の限度(バイト) 日本語は1文字2バイトです。

unless(-e './common.pl'){
	&error("common.plがありません。");
}
require './common.pl';


my($buff,%FORM,@keylist,$lockflag);
$passflag=0;
if($ENV{'REQUEST_METHOD'} eq "POST"){
	if($ENV{'CONTENT_LENGTH'}>$maxsize){
		&error("投稿量が多すぎます。");
	}
		read(STDIN,$buff,$ENV{'CONTENT_LENGTH'});
	}
else{
	$buff=$ENV{'QUERY_STRING'};
}

if($buff){
	&decode;
}

sub decode{
	my(@pairs,$pair,$value,$name);
	@pairs=split(/&/,$buff);
	foreach $pair(@pairs){
		($name,$value)=split(/=/,$pair);
		$value=~tr/+/ /;
		$value=~s/%([a-fA-F0-9][a-fA-F0-9])/pack("H2",$1)/eg;
		$value=~s/&/&amp;/g;
		$value=~s/</&lt;/g;
		$value=~s/>/&gt;/g;
		$value=~s/"/&quot;/g;
		$value=~s/'/&#039;/g;
		$value=~s/,/&#44;/g;
		$value=~s/\x0D\x0A//g;
		$value=~s/\x0A//g;
		$value=~s/\x0D//g;
		$FORM{$name}=$value;
	}

}


if($FORM{'mode'} eq "login"){
	&login;
}
elsif($FORM{'mode'} eq "check"){
	&check;
}
elsif($FORM{'mode'} eq "top"){
	&top;
}

elsif($FORM{'mode'} eq "regist"){
	&regist;
}
elsif($FORM{'mode'} eq "del"){
	if($FORM{'edit'} eq '削除'){
		&del;
	}
	elsif($FORM{'edit'} eq '編集'){
		&edit;
	}
}

elsif($FORM{'mode'} eq "editregist"){
	if($FORM{'act'} eq "戻る"){
		&top("editcheck");
	}
	else{
		&editregist;
	}
}
elsif($FORM{'mode'} eq "holiday"){
	&holiday;
}
elsif($FORM{'mode'} eq "holidayregist"){
	&holidayregist;
}
else{
	&enter;
}


sub enter{

&header;

print <<EOM;
<div align=center>
<br>
<br>
管理パスワードを入力してください。<br>
<form action="$script" method="POST">
<input type="hidden" name="mode" value="top">
<table>
<tr>
<td>パスワード</td><td><input type="password" name="pass" size=10></td>
</tr>
</table>
<br>
<input type=submit value="ログイン">
</form>
</div>
</body>
</html>
EOM

exit;

}


sub checkpass{
if($_[0] ne $pd){
	&error("パスワードが違います。");
}
}


sub top{
my(
$mode,$sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst,
$mon_now,$year_now,$last,$first,@ho,$nextyear,$nextmonth,
$beforeyear,$beforemonth,$back,$next,$now,$h,$y,$m,$line,@data,@keys,$col,
$table,$tr2,$u,$j,$hflag,$select,$s,$flag,$data
);

&checkpass($FORM{'pass'});


$mode=$_[0];

($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst)=localtime(time);
$mon++;
$year=$year+1900;
$mon_now=$mon;
$year_now=$year;


if($FORM{'year'}){
	$year=$FORM{'year'};
}
if($FORM{'mon'}){
	$mon=$FORM{'mon'};
}

@days = (31,28,31,30,31,30,31,31,30,31,30,31);

if( (($year%4 ==0)&&($year%100 != 0))||($year%400 == 0) ){
    	$days[1]=29;
}



$last=$days[$mon-1];
$first = &wday($year,$mon,1);

@ho=&holiday($year,$mon,$first,$last);

if($mon==12){
	$nextyear=$year+1;
	$nextmonth=1;
}
else{
	$nextmonth=$mon+1;
	$nextyear=$year;
}

if($mon==1){
	$beforeyear=$year-1;
	$beforemonth=12;
}
else{
	$beforemonth=$mon-1;
	$beforeyear=$year;
}

$back="<a href=\"javascript:void(0)\" onclick=\"Move_top('$beforeyear','$beforemonth')\">前←</a>";
$next="<a href=\"javascript:void(0)\" onclick=\"Move_top('$nextyear','$nextmonth')\">→次</a>";


$now="$year年$mon月";

if($mon == $mon_now && $year == $year_now){
	$back="";
}


open(FILE,"$logfile") || &error("$logfileが開けません。");
while(<FILE>){
	($h,$data)=split(/φ/,$_);
	($y,$m)=split(/\//,$h);
	if($y == $year && $m == $mon){
		$line=$data;
		last;
	}
}
close FILE;

@data=split(/,/,$line);
pop @data;

&header($_[0]);

print <<EOM;
<center>
<table border="0" width="750">
<tr>
<td width="30%"><font color="#FF0000">
$back
</font></td>
<td align="center" width="40%"><font color="#FF0000"> 
$now
</font></td>
<td align="right" width="30%"><font color="#FF0000"> 
$next
</font></td>
</tr>
</table>
<form action="$script" method="POST">
<input type=hidden name="mode" value="regist">
<input type=hidden name="pass" value="$FORM{'pass'}">
<input type=hidden name="year" value="$year">
<input type=hidden name="mon" value="$mon">
<input type=hidden name="last" value="$last">
EOM

@keys=keys %status;
@keys=sort{$a<=>$b}@keys;

$col=0;
$table="<table class=\"tb\" cellpadding=\"2\">";
$table.="<tr bgcolor=\"#ffcccc\">";
$table.="<td align=center width=100>日</td><td align=center width=100>月</td><td align=center width=100>火</td><td align=center width=100>水</td><td align=center width=100>木</td><td align=center width=100>金</td><td align=center width=100>土</td>\n";
$table.="</tr>";

if($first != 0){
	$table.="<tr>";
	$tr2.="<tr>\n";
	for($i=0;$i<$first;$i++){ 
		$table.="<td>　</td>";
		$tr2.="<td>　</td>";
		$col++;
	}
}
$u=0;
for($i=1;$i<=$last;$i++){
	$j=$i-1;
	if($col==0){
		$table.="<tr>\n";
		$tr2.="<tr>\n";
	}
	$hflag=0;
	foreach(@ho){
		if($_ == $i){
			$hflag=1;
			last;
		}
	}
	if($hflag || $col == 0){
		$t1="<font color=\"#ff0000\">";
		$t2="</font>";
	}
	else{
		$t1="";
		$t2="";
	}

	$table.="<td align=center>$t1$i$t2</td>";
	$select="<select name=\"s_$i\">\n<option value=\"\">選択</option>\n";
	foreach(@keys){
		if($_ == $data[$j]){
			$s=" selected";
		}
		else{
			$s="";
		}
		$select.="<option value=\"$_\"$s style=\"background-color:$bcolor{$_};color:$color{$_}\">$status{$_}</option>\n";
	}
	$select.="</select>\n";
	$tr2.="<td align=center>$select</td>";
	$col++;
	if($col>=7){ 
		$table.="</tr>";
		$tr2.="</tr>\n";
		$table.=$tr2;
		$tr2="";
        	if($i < $last){
			$col=0;
		}
	}
	$u++;
}
$flag=0;
for($i=$col;$i<7;$i++){
	$flag=1;
	$table.="<td>　</td>";
	$tr2.="<td>　</td>";
}

if($flag){
	$table.=$tr2;
	$table.="</tr>\n";
}

$table.="</table>";

print $table;
print <<EOM;
<br>
<input type="submit" value="登録">
</form>
</center>
<form name="fomove_top" action="$mscript" method="POST" style="margin:0px">
<input type="hidden" name="pass" value="$FORM{'pass'}">
<input type="hidden" name="mode" value="top">
<input type="hidden" name="year" value="">
<input type="hidden" name="mon" value="">
</form>
<script type="text/javascript">
function Move_top(y,m){
document.fomove_top.year.value=y;
document.fomove_top.mon.value=m;
document.fomove_top.submit();
}
</script>
</body>
</html>
EOM
exit;
}

sub regist{
my(
$dum,$mon_now,$year_now,$now,$no,$year,$mon,$last,@data,
$t,$line,$flag,$flag2,$h,$y,$m,$tuki,@new,$idx
);

($dum,$dum,$dum,$dum,$mon_now,$year_now)=localtime(time);
$mon_now++;
$year_now=$year_now+1900;
$mon_now=sprintf("%02d",$mon_now);
$now="$year_now$mon_now";


$no=$FORM{'year'}."/".$FORM{'mon'};
$year=$FORM{'year'};
$mon=$FORM{'mon'};
$last=$FORM{'last'};
$data[$last-1]="";

for($i=1;$i<=$last;$i++){
	$t="s_$i";
	if($FORM{$t}){
		$data[$i-1]=$FORM{$t};
	}
}

push @data,"\n";
$line=join(",",@data);
$line=$no."φ".$line;

$flag=0;
$idx=0;
open(FILE,"$logfile") || &error("$logfileが開けません。");
while(<FILE>){
	$flag2=0;
	($h)=split(/φ/,$_);
	($y,$m)=split(/\//,$h);
	$m_f=sprintf("%02d",$m);
	$tuki="$y$m_f";
	if($y == $year && $m == $mon){
		$flag=1;
		$_=$line;
	}
	elsif($tuki < $now){
		$flag2=1;
	}
	if(!$flag2){
		$new[$idx]=$_;
		$idx++;
	}
}
close FILE;

if(!$flag){
	push @new,$line;
}


open FILE,">$logfile" || &error("$logfileが開けません。");
print FILE @new;
close FILE;


&top("end");

}

sub end{
&header;

print <<EOM;
<center>
$_[0]<br>
<form name="fomove_top" action="$script" method="POST" style="display:inline"><input type="hidden" name="mode" value="top"><input type="hidden" name="pass" value="$FORM{'pass'}"><a href="javascript:void(0)" onclick="document.fomove_top.submit();">戻る</a></form>

</center>

</body>
</html>
EOM
exit;
}



sub holiday{
my($year,$mon,$col,$start,$lastday,$i,
$m,$d,@kotei,@daini_mon,@daisan_mon,$mcount,@ho,
$mcount,$kokuflag,$kokucount
);

$year=$_[0];
$mon=$_[1];
$start=$_[2];
$lastday=$_[3];

unless(open(FILE,$holiday_kotei)){
	&error("$holiday_koteiが開けません。ファイルを確認してください。");
}
while(<FILE>){
	$_=~s/\n$//;
	($m,$d)=split(/\//,$_);
	if($m == $mon){
		push @kotei,$d;
	}
}
close FILE;


unless(open(FILE,$holiday_daini)){
	&error("$holiday_dainiが開けません。ファイルを確認してください。");
}
while(<FILE>){
	$_=~s/\n$//;
	if($mon == $_){
		push @daini_mon,$_;
	}
}
close FILE;


unless(open(FILE,$holiday_daisan)){
	&error("$holiday_daisanが開けません。ファイルを確認してください。");
}
while(<FILE>){
	$_=~s/\n$//;
	if($mon == $_){
		push @daisan_mon,$_;
	}
}
close FILE;

if($mon == 3){
	$d = int(20.8431+0.242194*($year-1980)-int(($year-1980)/4));
	push @kotei,$d;
}
elsif($mon == 9){
	$d = int(23.2488+0.242194*($year-1980)-int(($year-1980)/4));
	push @kotei,$d;
}

if(!@kotei && !@daini_mon && !@daisan_mon){
	return @ho;
}


$col=0;
if($start!=0){
	for($i=0;$i<$start;$i++){
		$col++;
	}
}



$mcount=0;
$kokuflag=0;
$kokucount=0;
for($i=1;$i<=$lastday;$i++){
	$hflag=0;
	if($col == 1){
		$mcount++;
		if($mcount == 2){
			if(@daini_mon){
				push @ho,$i;
				$hflag=1;
			}

		}
		elsif($mcount == 3){
			if(@daisan_mon){
				push @ho,$i;
				$hflag=1;
			}
		}
	}
	foreach(@kotei){
		if($i == $_){
			if($col == 0){
				$flag=1;
			}
			else{
				push @ho,$i;
				$hflag=1;
			}
		}
	}
	if($col != 0){
		if($flag && !$hflag){
			push @ho,$i;
			$flag=0;
		}
	}
	if($kokuflag){
		if(!$hflag){
			$kokucount++;
		}
		else{
			if($kokucount == 2){
				push @ho,$i-1;
				$kokuflag=0;
				$kokucount=0;
			}
			elsif($kokucount > 2){
				$kokuflag=0;
				$kokucount=0;
			}
		}
	}
	if($hflag && !$kokuflag){
		$kokuflag=1;
		$kokucount++;
	}

	$col++;
	if($col>=7){ 
		if($i<$lastday){
			$col=0;
		}
	}

}

return(@ho);
}



sub wday {
my($year,$month,$day);
($year,$month,$day)=@_;
if($month<3){
	$month+=12;
	$year--;
}
return ($year+int($year/4)-int($year/100)+int($year/400)+int((13*$month+8)/5)+$day)% 7;
}




sub header{
my($on);
print <<EOM;
Content-type: text/html

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<title>$pagetitle</title>
<style type="text/css">
.tb{ 
border:1px solid #888888;
border-collapse:collapse;
}
.tb td{ 
border:1px solid #888888;
border-collapse:collapse;
font-size:10pt;
}
</style>


EOM

if($_[0] eq "end"){
print <<'EOM';
<script type="text/JavaScript">
function Alert(){
alert("登録しました。");
}
</script>
EOM
$on=" onload=\"Alert()\"";
}

print <<EOM;
</head>
<body text="#000000" bgcolor="#ffffff" link="#0000ff" vlink="#0000ff" alink="#0000ff"$on>
EOM




}


sub error{

&header;

print <<EOM;
<br>
<br>
<div align="center">ERROR</div>
<hr width="320" noshade size="1" color="#cccccc">
<table width=346 align=center><tr><td align=center>
EOM
print"$_[0]\n";
print <<EOM;
<br><br>
ブラウザのBackでお戻りください。
</td></tr></table>

</body>
</html>
EOM
exit;
}
exit;