#!/usr/bin/perl

#↑Perlのパス サーバーのマニュアルをみて確認する

#Calendar ver.3

#-------------- 基本設定------------

$script="cal.cgi";
$calskin='skin.html';

#---------------------------------------------

$maxsize=10000;		#投稿量の限度(バイト) 日本語は1文字2バイトです。


unless(-e './common.pl'){
	&error("common.plがありません。");
}
require './common.pl';


my($buff,%FORM,@keylist,$lockflag);
$passflag=0;
if($ENV{'REQUEST_METHOD'} eq "POST"){
	if($ENV{'CONTENT_LENGTH'}>$maxsize){
		&error("投稿量が多すぎます。");
	}
		read(STDIN,$buff,$ENV{'CONTENT_LENGTH'});
	}
else{
	$buff=$ENV{'QUERY_STRING'};
}

if($buff){
	&decode;
}

sub decode{
	my(@pairs,$pair,$value,$name);
	@pairs=split(/&/,$buff);
	foreach $pair(@pairs){
		($name,$value)=split(/=/,$pair);
		$value=~tr/+/ /;
		$value=~s/%([a-fA-F0-9][a-fA-F0-9])/pack("H2",$1)/eg;
		$value=~s/&/&amp;/g;
		$value=~s/</&lt;/g;
		$value=~s/>/&gt;/g;
		$value=~s/"/&quot;/g;
		$value=~s/'/&#039;/g;
		$value=~s/,/&#44;/g;
		$value=~s/\x0D\x0A//g;
		$value=~s/\x0A//g;
		$value=~s/\x0D//g;
		$FORM{$name}=$value;
	}

}


&Calendar;


sub Calendar{

my($skinline,$head,$dummy,$tr,$footer,
$sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst,
$mon_now,$year_now,$h,$data,$y,$m,$line,
@data,@days,$last,$first,@ho,$nextyear,$nextmonth,$beforeyear,$beforemonth,$back,$next,$now,
$m_f,$col,$table,$tr_d,$i,$d_f,$j,$hflag,$hoflag,$kflag);

unless(open(HTML, $calskin)){
	&error("$calskinが開けません。ファイル名を確認してください。");
}
$skinline = join('',<HTML>);
close(HTML);


($head,$dummy)=split(/<!--start-->/,$skinline);
if($head eq ""){
	&error("$calskinに&lt;--start--&gt;が書かれていません。");
}
($tr,$footer)=split(/<!--end-->/,$dummy);
if($tr eq ""){
	&error("$calskinに&lt;--end--&gt;が書かれていません。");
}

($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst)=localtime(time);
$mon++;
$year=$year+1900;

$mon_now=$mon;
$year_now=$year;

if($FORM{'year'}){
	$year=$FORM{'year'};
}
if($FORM{'month'}){
	$mon=$FORM{'month'};
}

open(FILE,"$logfile") || &error("$logfileが開けません。");
while(<FILE>){
	($h,$data)=split(/φ/,$_);
	($y,$m)=split(/\//,$h);
	if($y == $year && $m == $mon){
		$line=$data;
		last;
	}
}
close FILE;

@data=split(/,/,$line);
pop @data;

@days = (31,28,31,30,31,30,31,31,30,31,30,31);

if( (($year%4 ==0)&&($year%100 != 0))||($year%400 == 0) ){
    	$days[1]=29;
}

$last=$days[$mon-1];
$first = &wday($year,$mon,1);

@ho=&holiday($year,$mon,$first,$last);

if($mon==12){
	$nextyear=$year+1;
	$nextmonth=1;
}
else{
	$nextmonth=$mon+1;
	$nextyear=$year;
}

if($mon==1){
	$beforeyear=$year-1;
	$beforemonth=12;
}
else{
	$beforemonth=$mon-1;
	$beforeyear=$year;
}

$back="<a href=\"$script?year=$beforeyear&month=$beforemonth\" style=\"text-decoration:none\">&lt;&lt;</a>";
$next="<a href=\"$script?year=$nextyear&month=$nextmonth\" style=\"text-decoration:none\">&gt;&gt;</a>";
$now="$year年$mon月";

$head=~s/<!--next-->/$next/;
if($year != $year_now || $mon != $mon_now){
	$head=~s/<!--back-->/$back/;
}

$head=~s/<!--now-->/$now/;

$m_f=sprintf("%02d",$mon);
$col=0;
$table="";
$tr_d=$tr;
if($first != 0){
	for($i=0;$i<$first;$i++){ 
		$tr_d=~s/<!--d-->/&nbsp;/;
		$col++;
	}
}
for($i=1;$i<=$last;$i++){
	$d_f=sprintf("%02d",$i);
	$j=$i-1;
	$hflag=0;
	$tt=$year.$m_f.$d_f;
	$hoflag=0;
	foreach(@ho){
		if($_ == $i){
			$hoflag=1;
			last;
		}
	}
	$kflag=0;
	if($col == 0 && $sun){
		$kflag=1;
	}
	elsif($col == 1 && $getu){
		$kflag=1;
	}
	elsif($col == 2 && $tue){
		$kflag=1;
	}
	elsif($col == 3 && $wed){
		$kflag=1;
	}
	elsif($col == 4 && $thu){
		$kflag=1;
	}
	elsif($col == 5 && $fri){
		$kflag=1;
	}
	elsif($col == 6 && $sat){
		$kflag=1;
	}

	if($kflag){
		$hflag=1;
	}
	else{
		if($hoflag){
			$hflag=1;
		}
	}

	if($data[$j]){
		$st=" style=\"background-color:$bcolor{$data[$j]};color:$color{$data[$j]}\"";
		$tr_d=~s/ id="$col"/$st/;
	}
	else{
		if($hflag){
			$st=" style=\"background-color:$bcolor{'1'};color:$color{'1'}\"";
			$tr_d=~s/ id="$col"/$st/;
		}
	}

	$d="$f1$i$f2";
	$tr_d=~s/<!--d-->/$d/;
	$col++;
	if($col>=7){ 
		$table.=$tr_d;
		$tr_d=$tr;
       		if($i<$last){
			$col=0;
		}
	}
}
if($col && $col != 7){
	$tr_d=~s/<!--d-->/&nbsp;/g;
	$table.=$tr_d;
}


print "Content-type: text/html\n\n";
print $head;
print $table;
print $footer;

exit;
}

sub holiday{
my($year,$mon,$col,$start,$lastday,$i,$m,$d,
@kotei,@daini_mon,@daisan_mon,$mcount,@ho,
$col,$mcount,$kokuflag,$kokucount);

$year=$_[0];
$mon=$_[1];
$start=$_[2];
$lastday=$_[3];

unless(open(FILE,$holiday_kotei)){
	&error("$holiday_koteiが開けません。ファイルを確認してください。");
}
while(<FILE>){
	$_=~s/\n$//;
	($m,$d)=split(/\//,$_);
	if($m == $mon){
		push @kotei,$d;
	}
}
close FILE;


unless(open(FILE,$holiday_daini)){
	&error("$holiday_dainiが開けません。ファイルを確認してください。");
}
while(<FILE>){
	$_=~s/\n$//;
	if($mon == $_){
		push @daini_mon,$_;
	}
}
close FILE;


unless(open(FILE,$holiday_daisan)){
	&error("$holiday_daisanが開けません。ファイルを確認してください。");
}
while(<FILE>){
	$_=~s/\n$//;
	if($mon == $_){
		push @daisan_mon,$_;
	}
}
close FILE;

if($mon == 3){
	$d = int(20.8431+0.242194*($year-1980)-int(($year-1980)/4));
	push @kotei,$d;
}
elsif($mon == 9){
	$d = int(23.2488+0.242194*($year-1980)-int(($year-1980)/4));
	push @kotei,$d;
}

if(!@kotei && !@daini_mon && !@daisan_mon){
	return @ho;
}


$col=0;
if($start!=0){
	for($i=0;$i<$start;$i++){
		$col++;
	}
}
$mcount=0;
$kokuflag=0;
$kokucount=0;
for($i=1;$i<=$lastday;$i++){
	$hflag=0;
	if($col == 1){
		$mcount++;
		if($mcount == 2){
			if(@daini_mon){
				push @ho,$i;
				$hflag=1;
			}

		}
		elsif($mcount == 3){
			if(@daisan_mon){
				push @ho,$i;
				$hflag=1;
			}
		}
	}
	foreach(@kotei){
		if($i == $_){
			if($col == 0){
				$flag=1;
			}
			else{
				push @ho,$i;
				$hflag=1;
			}
		}
	}
	if($col != 0){
		if($flag && !$hflag){
			push @ho,$i;
			$flag=0;
		}
	}
	if($kokuflag){
		if(!$hflag){
			$kokucount++;
		}
		else{
			if($kokucount == 2){
				push @ho,$i-1;
				$kokuflag=0;
				$kokucount=0;
			}
			elsif($kokucount > 2){
				$kokuflag=0;
				$kokucount=0;
			}
		}
	}
	if($hflag && !$kokuflag){
		$kokuflag=1;
		$kokucount++;
	}

	$col++;
	if($col>=7){ 
		if($i<$lastday){
			$col=0;
		}
	}

}

return(@ho);
}



sub wday {
my($year,$month,$day);
($year,$month,$day)=@_;
if($month<3){
	$month+=12;
	$year--;
}
return ($year+int($year/4)-int($year/100)+int($year/400)+int((13*$month+8)/5)+$day)% 7;
}



sub header{

print <<EOM;
Content-type: text/html

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<title>$pagetitle</title>
<style type="text/css">


</style>
</head>
<body text="#000000" bgcolor="#ffffff" link="blue" vlink="blue" alink="blue">
EOM


}


sub error{

&header;

print <<EOM;
<br>
<br>
<div align="center">ERROR</div>
<hr width="320" noshade size="1" color="#cccccc">
<table width=346 align=center><tr><td align=center>
EOM
print"$_[0]\n";
print <<EOM;
<br><br>

</td></tr></table>

</body>
</html>
EOM
exit;
}
exit;